import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/objectWithoutPropertiesLoose";
import _extends from "@babel/runtime/helpers/extends";
import _inheritsLoose from "@babel/runtime/helpers/inheritsLoose";
import React from 'react';
import { FixedSizeList } from 'react-window';
import Tree, { createTreeComputer } from './Tree';
import { createRecord, shouldUpdateRecords, updateRecord, updateRecordOnNewData } from './utils';
var computeTree = createTreeComputer({
  createRecord: createRecord,
  shouldUpdateRecords: shouldUpdateRecords,
  updateRecord: updateRecord,
  updateRecordOnNewData: updateRecordOnNewData
});
export var FixedSizeTree = /*#__PURE__*/function (_Tree) {
  _inheritsLoose(FixedSizeTree, _Tree);

  function FixedSizeTree(props, context) {
    var _this;

    _this = _Tree.call(this, props, context) || this;
    _this.state = _extends({}, _this.state, {
      computeTree: computeTree
    });
    return _this;
  }

  var _proto = FixedSizeTree.prototype;

  _proto.render = function render() {
    var _this$props = this.props,
        children = _this$props.children,
        treeWalker = _this$props.treeWalker,
        rowComponent = _this$props.rowComponent,
        rest = _objectWithoutPropertiesLoose(_this$props, ["children", "treeWalker", "rowComponent"]);

    return /*#__PURE__*/React.createElement(FixedSizeList, Object.assign({}, rest, {
      itemCount: this.state.order.length,
      itemData: this.state,
      ref: this.list
    }), rowComponent);
  };

  return FixedSizeTree;
}(Tree);