import { ReactNode } from 'react';
import { VariableSizeList, VariableSizeListProps } from 'react-window';
import Tree, { NodeComponentProps, NodeData, NodeRecord, TreeProps, TreeState, UpdateOptions } from './Tree';
export declare type VariableSizeNodeData = Readonly<{
    /** Default node height. Can be used only with VariableSizeTree */
    defaultHeight: number;
}> & NodeData;
export declare type VariableSizeNodeComponentProps<T extends VariableSizeNodeData> = NodeComponentProps<T> & Readonly<{
    height: number;
    resize: (height: number, shouldForceUpdate?: boolean) => void;
}>;
export declare type VariableSizeNodeRecord<T extends VariableSizeNodeData> = NodeRecord<T> & {
    height: number;
    readonly resize: (height: number, shouldForceUpdate?: boolean) => void;
};
export declare type VariableSizeUpdateOptions = UpdateOptions & Readonly<{
    useDefaultHeight?: boolean;
}>;
export declare type VariableSizeTreeProps<T extends VariableSizeNodeData> = TreeProps<VariableSizeNodeComponentProps<T>, T> & Readonly<{
    itemSize?: VariableSizeListProps['itemSize'];
}>;
export declare type VariableSizeTreeState<T extends VariableSizeNodeData> = TreeState<VariableSizeNodeComponentProps<T>, VariableSizeNodeRecord<T>, VariableSizeUpdateOptions, T> & Readonly<{
    resetAfterId: (id: string | symbol, shouldForceUpdate?: boolean) => void;
}>;
export declare class VariableSizeTree<T extends VariableSizeNodeData> extends Tree<VariableSizeNodeComponentProps<T>, VariableSizeNodeRecord<T>, VariableSizeUpdateOptions, T, VariableSizeTreeProps<T>, VariableSizeTreeState<T>, VariableSizeList> {
    constructor(props: VariableSizeTreeProps<T>, context: any);
    resetAfterId(id: string | symbol, shouldForceUpdate?: boolean): void;
    recomputeTree(options?: VariableSizeUpdateOptions): Promise<void>;
    render(): ReactNode;
    private getItemSize;
}
