import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/objectWithoutPropertiesLoose";
import _extends from "@babel/runtime/helpers/extends";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inheritsLoose from "@babel/runtime/helpers/inheritsLoose";
import React from 'react';
import { VariableSizeList } from 'react-window';
import Tree, { createTreeComputer } from './Tree';
import { shouldUpdateRecords as _shouldUpdateRecords, updateRecord as _updateRecord, updateRecordOnNewData as _updateRecordOnNewData } from './utils';
var computeTree = createTreeComputer({
  createRecord: function createRecord(data, _ref) {
    var recomputeTree = _ref.recomputeTree,
        resetAfterId = _ref.resetAfterId;
    var record = {
      data: data,
      height: data.defaultHeight,
      isOpen: data.isOpenByDefault,
      resize: function resize(height, shouldForceUpdate) {
        record.height = height;
        resetAfterId(record.data.id, shouldForceUpdate);
      },
      toggle: function toggle() {
        record.isOpen = !record.isOpen;
        return recomputeTree({
          refreshNodes: record.isOpen,
          useDefaultHeight: true
        });
      }
    };
    return record;
  },
  shouldUpdateRecords: function shouldUpdateRecords(options) {
    var _options$useDefaultHe;

    return _shouldUpdateRecords(options) || ((_options$useDefaultHe = options.useDefaultHeight) != null ? _options$useDefaultHe : false);
  },
  updateRecord: function updateRecord(record, recordId, options) {
    if (options.useDefaultHeight) {
      record.height = record.data.defaultHeight;
    }

    _updateRecord(record, recordId, options);
  },
  updateRecordOnNewData: function updateRecordOnNewData(record, options) {
    _updateRecordOnNewData(record, options);

    if (options.useDefaultHeight) {
      record.height = record.data.defaultHeight;
    }
  }
});
export var VariableSizeTree = /*#__PURE__*/function (_Tree) {
  _inheritsLoose(VariableSizeTree, _Tree);

  function VariableSizeTree(props, context) {
    var _this;

    _this = _Tree.call(this, props, context) || this;
    _this.getItemSize = _this.getItemSize.bind(_assertThisInitialized(_this));
    _this.state = _extends({}, _this.state, {
      computeTree: computeTree,
      resetAfterId: _this.resetAfterId.bind(_assertThisInitialized(_this))
    });
    return _this;
  }

  var _proto = VariableSizeTree.prototype;

  _proto.resetAfterId = function resetAfterId(id, shouldForceUpdate) {
    var _this$list$current;

    if (shouldForceUpdate === void 0) {
      shouldForceUpdate = false;
    }

    (_this$list$current = this.list.current) == null ? void 0 : _this$list$current.resetAfterIndex(this.state.order.indexOf(id), shouldForceUpdate);
  };

  _proto.recomputeTree = function recomputeTree(options) {
    var _this2 = this;

    return _Tree.prototype.recomputeTree.call(this, options).then(function () {
      var _this2$list$current;

      (_this2$list$current = _this2.list.current) == null ? void 0 : _this2$list$current.resetAfterIndex(0, true);
    });
  };

  _proto.render = function render() {
    var _this$props = this.props,
        children = _this$props.children,
        itemSize = _this$props.itemSize,
        rowComponent = _this$props.rowComponent,
        treeWalker = _this$props.treeWalker,
        rest = _objectWithoutPropertiesLoose(_this$props, ["children", "itemSize", "rowComponent", "treeWalker"]);

    return /*#__PURE__*/React.createElement(VariableSizeList, Object.assign({}, rest, {
      itemCount: this.state.order.length,
      itemData: this.state // eslint-disable-next-line @typescript-eslint/unbound-method
      ,
      itemSize: itemSize != null ? itemSize : this.getItemSize,
      ref: this.list
    }), rowComponent);
  };

  _proto.getItemSize = function getItemSize(index) {
    var _this$state = this.state,
        order = _this$state.order,
        records = _this$state.records;
    return records[order[index]].height;
  };

  return VariableSizeTree;
}(Tree);