import React from 'react';
import { FixedSizeList } from 'react-window';
import Tree, { createTreeComputer } from './Tree';
import { createRecord, shouldUpdateRecords, updateRecord, updateRecordOnNewData } from './utils';
const computeTree = createTreeComputer({
  createRecord,
  shouldUpdateRecords,
  updateRecord,
  updateRecordOnNewData
});
export class FixedSizeTree extends Tree {
  constructor(props, context) {
    super(props, context);
    this.state = { ...this.state,
      computeTree
    };
  }

  render() {
    const {
      children,
      treeWalker,
      rowComponent,
      ...rest
    } = this.props;
    return /*#__PURE__*/React.createElement(FixedSizeList, Object.assign({}, rest, {
      itemCount: this.state.order.length,
      itemData: this.state,
      ref: this.list
    }), rowComponent);
  }

}