import React, { ComponentType, PropsWithChildren, PureComponent, ReactElement } from 'react';
import { Align, FixedSizeList, ListChildComponentProps, ListProps, VariableSizeList } from 'react-window';
import { DefaultTreeProps, DefaultTreeState } from './utils';
export declare type NodeData = Readonly<{
    /**
     * Unique ID of the current node. Will be used to identify the node to change
     * its internal state.
     */
    id: string | symbol;
    /**
     * Default node openness state. If the Tree component performs rendering at
     * the first time or the "updateOpenness" property is provided, this value
     * will be used to set the internal openness state of the node.
     */
    isOpenByDefault: boolean;
}>;
export declare type UpdateOptions = Readonly<{
    opennessState?: Readonly<Record<string, boolean>>;
    refreshNodes?: boolean;
    useDefaultOpenness?: boolean;
}>;
export declare type NodeRecord<TData extends NodeData> = {
    data: TData;
    isOpen: boolean;
    readonly toggle: () => Promise<void>;
};
export declare type NodeComponentProps<TData extends NodeData> = Readonly<Omit<ListChildComponentProps, 'data' | 'index'>> & Readonly<{
    data: TData;
    isOpen: boolean;
    toggle: () => void;
    treeData?: any;
}>;
export declare type TreeWalker<T> = (refresh: boolean) => Generator<T | string | symbol, void, boolean>;
export declare type TreeProps<TNodeComponentProps extends NodeComponentProps<TData>, TData extends NodeData> = Readonly<Omit<ListProps, 'children' | 'itemCount'>> & Readonly<{
    children: ComponentType<TNodeComponentProps>;
    rowComponent?: ComponentType<ListChildComponentProps>;
    treeWalker: TreeWalker<TData>;
}>;
export declare type TreeState<TNodeComponentProps extends NodeComponentProps<TData>, TNodeRecord extends NodeRecord<TData>, TUpdateOptions extends UpdateOptions, TData extends NodeData> = Readonly<{
    component: ComponentType<TNodeComponentProps>;
    order?: ReadonlyArray<string | symbol>;
    computeTree: TreeComputer<TNodeComponentProps, TNodeRecord, TUpdateOptions, TData, any, any>;
    records: Readonly<Record<string, TNodeRecord | undefined>>;
    treeData?: any;
    recomputeTree: (options?: TUpdateOptions) => Promise<void>;
    treeWalker: TreeWalker<TData>;
}>;
export declare type TypedListChildComponentProps<TData extends NodeData> = Readonly<Omit<ListChildComponentProps, 'data'> & {
    data: Pick<TreeState<NodeComponentProps<TData>, NodeRecord<TData>, UpdateOptions, TData>, 'component' | 'order' | 'records' | 'treeData'>;
}>;
export declare const Row: <TData extends Readonly<{
    /**
     * Unique ID of the current node. Will be used to identify the node to change
     * its internal state.
     */
    id: string | symbol;
    /**
     * Default node openness state. If the Tree component performs rendering at
     * the first time or the "updateOpenness" property is provided, this value
     * will be used to set the internal openness state of the node.
     */
    isOpenByDefault: boolean;
}>>({ index, data: { component: Node, treeData, order, records }, style, isScrolling, }: React.PropsWithChildren<Readonly<Pick<ListChildComponentProps, "style" | "index" | "isScrolling"> & {
    data: Pick<Readonly<{
        component: React.ComponentType<NodeComponentProps<TData>>;
        order?: readonly (string | symbol)[] | undefined;
        computeTree: TreeComputer<NodeComponentProps<TData>, NodeRecord<TData>, Readonly<{
            opennessState?: Readonly<Record<string, boolean>> | undefined;
            refreshNodes?: boolean | undefined;
            useDefaultOpenness?: boolean | undefined;
        }>, TData, any, any>;
        records: Readonly<Record<string, NodeRecord<TData> | undefined>>;
        treeData?: any;
        recomputeTree: (options?: Readonly<{
            opennessState?: Readonly<Record<string, boolean>> | undefined;
            refreshNodes?: boolean | undefined;
            useDefaultOpenness?: boolean | undefined;
        }> | undefined) => Promise<void>;
        treeWalker: TreeWalker<TData>;
    }>, "order" | "treeData" | "component" | "records">;
}>>) => ReactElement | null;
export declare type TreeCreatorOptions<TNodeComponentProps extends NodeComponentProps<TData>, TNodeRecord extends NodeRecord<TData>, TUpdateOptions extends UpdateOptions, TData extends NodeData, TState extends TreeState<TNodeComponentProps, TNodeRecord, TUpdateOptions, TData>> = Readonly<{
    createRecord: (data: TData, state: TState) => TNodeRecord;
    shouldUpdateRecords: (options: TUpdateOptions) => boolean;
    updateRecord: (record: TNodeRecord, recordId: string | symbol, options: TUpdateOptions) => void;
    updateRecordOnNewData: (record: TNodeRecord, options: TUpdateOptions) => void;
}>;
export declare type TreeComputer<TNodeComponentProps extends NodeComponentProps<TData>, TNodeRecord extends NodeRecord<TData>, TUpdateOptions extends UpdateOptions, TData extends NodeData, TProps extends TreeProps<TNodeComponentProps, TData>, TState extends TreeState<TNodeComponentProps, TNodeRecord, TUpdateOptions, TData>> = (props: TProps, state: TState, options?: TUpdateOptions) => Pick<TState, 'order' | 'records'>;
export declare const createTreeComputer: <TNodeComponentProps extends NodeComponentProps<TData>, TNodeRecord extends NodeRecord<TData>, TUpdateOptions extends Readonly<{
    opennessState?: Readonly<Record<string, boolean>> | undefined;
    refreshNodes?: boolean | undefined;
    useDefaultOpenness?: boolean | undefined;
}>, TData extends Readonly<{
    /**
     * Unique ID of the current node. Will be used to identify the node to change
     * its internal state.
     */
    id: string | symbol;
    /**
     * Default node openness state. If the Tree component performs rendering at
     * the first time or the "updateOpenness" property is provided, this value
     * will be used to set the internal openness state of the node.
     */
    isOpenByDefault: boolean;
}>, TProps extends TreeProps<TNodeComponentProps, TData>, TState extends Readonly<{
    component: React.ComponentType<TNodeComponentProps>;
    order?: readonly (string | symbol)[] | undefined;
    computeTree: TreeComputer<TNodeComponentProps, TNodeRecord, TUpdateOptions, TData, any, any>;
    records: Readonly<Record<string, TNodeRecord | undefined>>;
    treeData?: any;
    recomputeTree: (options?: TUpdateOptions | undefined) => Promise<void>;
    treeWalker: TreeWalker<TData>;
}>>({ createRecord, shouldUpdateRecords, updateRecord, updateRecordOnNewData, }: Readonly<{
    createRecord: (data: TData, state: TState) => TNodeRecord;
    shouldUpdateRecords: (options: TUpdateOptions) => boolean;
    updateRecord: (record: TNodeRecord, recordId: string | symbol, options: TUpdateOptions) => void;
    updateRecordOnNewData: (record: TNodeRecord, options: TUpdateOptions) => void;
}>) => TreeComputer<TNodeComponentProps, TNodeRecord, TUpdateOptions, TData, TProps, TState>;
declare class Tree<TNodeComponentProps extends NodeComponentProps<TData>, TNodeRecord extends NodeRecord<TData>, TUpdateOptions extends UpdateOptions, TData extends NodeData, TProps extends TreeProps<TNodeComponentProps, TData>, TState extends TreeState<TNodeComponentProps, TNodeRecord, TUpdateOptions, TData>, TListComponent extends FixedSizeList | VariableSizeList> extends PureComponent<TProps, TState> {
    static defaultProps: Partial<DefaultTreeProps>;
    static getDerivedStateFromProps(props: DefaultTreeProps, state: DefaultTreeState): Partial<DefaultTreeState>;
    protected readonly list: React.RefObject<TListComponent>;
    constructor(props: TProps, context: any);
    recomputeTree(options?: TUpdateOptions): Promise<void>;
    scrollTo(scrollOffset: number): void;
    scrollToItem(id: string | symbol, align?: Align): void;
}
export default Tree;
