export const identity = value => value;
export const createRecord = (data, {
  recomputeTree
}) => {
  const record = {
    data,
    isOpen: data.isOpenByDefault,

    toggle() {
      record.isOpen = !record.isOpen;
      return recomputeTree({
        refreshNodes: record.isOpen
      });
    }

  };
  return record;
};
export const shouldUpdateRecords = ({
  opennessState,
  useDefaultOpenness = false
}) => !!opennessState || useDefaultOpenness;
export const updateRecord = (record, recordId, {
  opennessState,
  useDefaultOpenness = false
}) => {
  var _opennessState;

  record.isOpen = useDefaultOpenness ? record.data.isOpenByDefault : (_opennessState = opennessState == null ? void 0 : opennessState[recordId]) != null ? _opennessState : record.isOpen;
};
export const updateRecordOnNewData = (record, {
  useDefaultOpenness = false
}) => {
  if (useDefaultOpenness) {
    record.isOpen = record.data.isOpenByDefault;
  }
};