tanker-kit
----------
npm-пакет для работы с Танкером

Возможности:
* Парсинг исходников;
* Загрузка и выгрузка данных из Танкера;
* Программный и консольный интерфейс;
* Всячески конфигурируется и расширяется.

Общие сведения
--------------

Утилита `tanker-kit` предназначена для работы с сервисом переводов [Яндекс.Танкер](https://tanker.yandex-team.ru/).

С её помощью можно осуществлять:
* Поиск и извлечение локализационных ключей из исходных файлов (парсинг);
* Загрузку, выгрузку и синхронизацию данных с Танкером.

[Яндекс.Танкер]: http://doc.yandex-team.ru/Tanker/tech-dscr/concepts/tanker-description.xml


Особенности реализации
----------------------

* Утилита написана на Javascript и поставляется в виде npm-пакета;
* Пакет находится во внутреннем регистре http://npm.yandex-team.ru;
* Все значимые этапы работы программы конфигурируются и расширяются;
* Утилита не использует какую-либо схему локализации, вся конкретика реализуется в модулях расширения;
* Утилита имеет набор стандартных модулей расширения, которые находятся в отдельном пакете [tanker-ext][];
* С утилитой поставляются модули расширения для проектов, использующих схему локализации [BEM.I18N][].

[BEM.I18N]: https://islands-lego.yandex-team.ru/doc/practics/localization/


Установка
---------

Рекомендуется локальная установка пакета:

    npm i tanker-kit --save-dev --registry http://npm.yandex-team.ru


Хелпер для запуска
------------------

Чтобы запуск установленного локально `tanker-kit` был доступен по короткому имени `tanker`, нужно установить пакет `tanker-cli`. Пакет `tanker-cli` - это хелпер, аналогичный `grunt-cli`, `bem-cli` и другим `*-cli`.

    sudo npm i tanker-cli -g --registry http://npm.yandex-team.ru


Автокомплит
-----------

В связке с `tanker-cli` или глобально установленным `tanker-kit` можно установить себе автокомплит.

Для bash:

    tanker comp --shell >> ~/.bash_profile

Для zsh:

    tanker comp --shell >> ~/.zshrc


Инициализация
-------------

Чтобы использовать в проекте `tanker-kit` нужно создать файл с настройками, специфичными для проекта.
Для этого в корневом каталоге проекта нужно запустить команду:

    tanker init

После запуска команды, пользователю в интерактивном режиме будет предложено ввести основные настройки проекта:
* Название проекта в Танкере (например, serp);
* Токен для роботов. Его можно найти на странице проекта в танкере. [Пример для проекта serp](https://tanker.yandex-team.ru/?project=serp-web4);
* Набор консольных команд для поиска исходников (например, `find blocks-* -name *.priv.js`).

После выполнения команды в корневом каталоге проекта будет создан подкаталог `.tanker` с конфигурационным файлом проекта `config.js`.

`.tanker` - это служебный каталог в котором хранятся конфигурационный файл проекта, проектный резолвер, и другие служебные файлы программы.

Если в проекте используется GIT, то путь до файла лога можно сразу добавить в `.gitignore`:

    echo '/.tanker/log.json' >> .gitignore


Конфигурирование
----------------

Настройка проекта для работы с `tanker-kit` осуществляется с помощью файла `.tanker/config.js` - конфигурационного файла проекта.
Предполагается, что этот файл был создан на этапе инициализации, командой `tanker init`. В этом случае файл `config.js` уже содержит базовые настройки:
* ID проекта в танкере;
* Токен для роботов;
* Набор консольных команд для поиска исходников.

Конфигурационный файл представляет собой модуль Node.js, экспортирующий функцию.
Функция принимает единственный аргумент - объект с базовый конфигурацией, далее конфиг.

Функция задает специфичные для проекта настройки, определяя или переопределяя [те или иные поля](#-5) базового конфига.

Функция может вернуть промис, тогда программа дождется пока промис разрезолвится и только после этого продолжит исполнение.

Важно:
* Функция не возвращает конфиг, она модифицирует переданный ей объект;
* Не рекомендуется изменять секцию `paths` базового конфига.


Резолвинг
---------

Зачастую данные, полученные из исходных файлов в процессе парсинга нуждаются в дополнении - резолвинге.
Частично или полностью автоматизировать процесс резолвинга данных для новых ключей можно с помощью файла
`.tanker/resolver.js` - проектном резолвере.

Этот файл представляет собой модуль Node.js, экспортирующий функцию.
Он работает аналогично конфигурационному файлу проекта, но в качестве аргумента принимает ключ,
требующий резолвинга данных.

С помощью проектного резолвера можно значительно сократить или полностью исключить этап интерактивного
опроса пользователя.


Этапы работы программы
----------------------

Каждый этап реализован в отдельном модуле.
Разные команды задействуют какое-то подмножество этих этапов.

### Конфигурирование

**модуль** — [`./lib/config.js`](../lib/config.js).

Конфигурирование - это начальный этап работы утилиты.
На этом этапе формируется конфиг, который в дальнейшем используется на других этапах работы программы.

[Базовый конфиг](../cnf/base.json) содержит все поля, которые могут быть использованы в процессе работы программы.
Не существует осмысленных полей, которые не были бы указаны в базовом конфиге.
Для некоторых полей выставлены значения по умолчанию, другие указаны как плейсхолдеры со значением `null`.

Конфиг формируется следующим образом:

1. За основу берется базовый конфиг;
1. Конфиг передается в функцию, реализующую корректировочные runtime-расширения (доступны только через программное API);
1. Конфиг передается в функцию, реализующую [базовые runtime-расширения](../cnf/runtime.js);
1. Конфиг передается в функцию, реализующую проектные runtime-расширения (функция, экспортируемая проектным конфигурационным файлом);
1. Из конфига убирается синтаксический сахар и неоднозначности.

Сформированный конфиг можно посмотреть с помощью команды:

    tanker conf


### Поиск

**модуль** — [`./lib/find.js`](../lib/find.js).

На этом этапе из корня проекта последовательно исполняются все команды, указанные в конфиге в поле `finders` конфига.
Пути, полученные после исполнения команд из `finders`, приводятся к абсолютному виду.
Затем из них удаляются дубли и пути не соответствующие фильтр-префиксу (поле `paths.fprefix`).

В результате получается массив путей до исходных файлов, предположительно содержащих локализационные ключи.

Список найденных файлов можно посмотреть с помощью команды:

    tanker find

Команды, указанные в `finders` исполняются с помощью [child_process.exec](https://nodejs.org/api/child_process.html#child_process_child_process_exec_command_options_callback). Если необходимо поменять размер буфера для stdout команд (параметр `maxBuffer`), можно воспользоваться переменной окружения `FIND_EXEC_BUFFER_SIZE`, например `FIND_EXEC_BUFFER_SIZE=1000000 tanker find`

### Парсинг

**модуль** — [`./lib/parse.js`](../lib/parse.js).

На этом этапе из файлов исходников формируется массив содержащихся в них ключей.
Извлечение ключей производится модулями расширения, **парсерами**, указанными в секции `parsers` конфига.

Каждый ключ — это хеш, хранящий информацию о различных параметрах ключа в Танкере и служебную информацию о фрагменте исходного кода.

Список найденных ключей можно посмотреть с помощью команды:

    tanker keys


### Резолвинг

**модуль** — [`./lib/resolve.js`](../lib/resolve.js).

В процессе парсинга не всегда возможно получить все данные для того или иного ключа,
необходимые для его выгрузки в Танкер. Недостающие данные нужно дополнить или уточнить.

Схема обработки тех или иных полей ключа задается в секции `resolving` конфига.
На основе этих настроек определяются поля, нуждающиеся в резолвинге.

Данные ключа могут уточняться:

* Результатами резолвинга, сохраненными при предыдущих запусках программы в проектной карте ключей;
* Проектным резолвером;
* Пользователем в интерактивном режиме.

Резолвинг производится по следующей схеме:

1. Выбираются те ключи, которые есть в карте. Эти данные считаются достоверными;
1. Ключи, которых в карте не найдено, передаются проектному резолверу;
1. Если после выполнения проектного резолвера остались поля которые нужно уточнить, для них запускается интерактивный опрос пользователя.

Когда все данные получены, новые ключи добавляются в проектную карту ключей,
и при следующем запуске программы данные по ним больше не уточняются.
Проектная карта ключей хранится в файле `.tanker/map.json`.

Уточненные данные ключей можно посмотреть с помощью команды:

    tanker keys -m

При этом ключи в которых остались неполные данные будут отмечены красным.

### Форматирование

**модуль** — [`./lib/format.js`](../lib/format.js).

На этом этапе массив ключей, полученный после резолвинга, преобразуется в формат, пригодный для отправки в танкер.
Преобразование происходит в модуле расширения, **форматтере**, указанном в конфиге в секции `formatters`.

Посмотреть сформированные данные, не отправляя их в Танкер, можно с помощью команды:

    tanker push -d

### Отправка в Танкер

**модуль** — [`./lib/push.js`](../lib/push.js).

На этом этапе отформатированные данные загружаются в Танкер.

Добавление переводов осуществляется с помощью ручки [/keysets/onlyadd/][].
Добавляются только те ключи, которых еще нет в Танкере. Существующие ключи не изменяются.

Отправить данные в Танкер можно с помощью команды:

    tanker push

[/keysets/onlyadd/]: http://doc.yandex-team.ru/Tanker/api-reference/concepts/operations-translations.xml#trans-add


### Выгрузка из Танкера

**модуль** — [`./lib/pull.js`](../lib/pull.js).

Выгрузка данных из Танкера производится в зависимости от значения поля `tanker.force` конфига.
Это будут либо переводы, для ревизии, зафиксированной в файле `.tanker/ref.json`,
либо самые свежие переводы из ветки, указанной в поле `tanker.branch`.

Посмотреть данные, пришедшие из Танкера, не раскладывая их по файловой системе, можно с помощью команды:

    tanker pull -d


### Диспетчеризация

**модуль** — [`./lib/dispatch.js`](../lib/dispatch.js).

На этом этапе программа производит раскладку данных, полученных из Танкера, по файловой системе.
Преобразование производится с помощью модуля расширения, **диспетчера**, указанного в секции `dispatchers` конфига.

Структура конфига
-----------------

* Все поля имеют строковый тип данных, если иное не указано явно;
* Пути до своих модулей расширения рекомендуется указывать в абсолютном виде.


### Секция paths

В этой секции указываются пути до файлов и каталогов, которые используются программой.
Это базовые настройки, изменять их не рекомендуется. Все пути абсолютные.

| Поле        | Описание                                                               | По умолчанию                               | Примечания                      |
|:------------|:-----------------------------------------------------------------------|:-------------------------------------------|:--------------------------------|
| `root`      | Корневой каталог проекта                                               | Ближайший каталог с подкаталогом `.tanker` |                                 |
| `fprefix`   | Фильтр-префикс для поиска                                              | `process.cwd()`                            | Должен быть внутри `paths.root` |
| `tankerDir` | Каталог с проектным файлом конфигурации и служебными файлами программы | `.tanker`                                  |                                 |
| `tankerCnf` | Проектный файл конфигурации                                            | `.tanker/config.js`                        |                                 |
| `tankerRsl` | Проектный резолвер                                                     | `.tanker/resolver.js`                      |                                 |
| `tankerRef` | Метка с текущей ревизией переводов                                     | `.tanker/ref.json`                         |                                 |
| `tankerMap` | Карта ключей                                                           | `.tanker/map.json`                         |                                 |
| `tankerLog` | Лог                                                                    | `.tanker/log.json`                         |                                 |


### Секция tanker

В этой секции указываются настройки, используемые при обращениях к API Яндекс.Танкер.

| Поле       | Описание                          | По умолчанию                         | Примечания    |
|:-----------|:----------------------------------|:-------------------------------------|:--------------|
| `host`     | Хост                              | `"tanker-api.yandex-team.ru"`        | Без протокола |
| `project`  | ID проекта в Танкере              | `null`                               |               |
| `token`    | OAuth токен для роботов           | `null`                               |               |
| `branch`   | Ветка                             | `"master"`                           |               |
| `hash`     | Ревизия                           | Берется из `paths.tankerRef`         |               |
| `original` | Оригинальный язык проекта         | `"ru"`                               |               |
| `langs`    | Параметр [language][td]           | `null` (все)                         |               |
| `status`   | Параметр [status][td]             | `null`                               |               |
| `safe`     | Параметр [safe][td]               | `true`                               | `{Boolean}`   |
| `flat`     | Параметр [flat-keyset][td]        | `true`                               | `{Boolean}`   |
| `forms`    | Параметр [all-forms][td]          | `true`                               | `{Boolean}`   |
| `push`     | Формат данных для отправки        | `"tjson"`                            |               |
| `pull`     | Формат данных для загрузки        | `"json"`                             |               |
| `force`    | Загружать по ревизии или по хеду. | `false` (по ревизии)                 | `{Boolean}`   |

NB:
* Если используется тестовый Танкер, в поле `host` можно просто написать `"test"`.
* В поле `langs` может быть массив с перечислением языков или строка где языки перечислены через запятую.
* Получить OAuth-токен для робота можно по ссылке: https://nda.ya.ru/3SjQY7.

[td]: http://doc.yandex-team.ru/Tanker/api-reference/concepts/operations-translations.xml#trans-download


### Секция finders

В этой секции указываются команды для поиска файлов.

Секция `finders` это массив, каждый элемент которого - строка с консольной командой.
Все команды исполняются из корневого каталога проекта.

В совокупности результаты исполнения этих команд должены сформировать список путей до всех файлов проекта,
в которых могут содержаться локализационные ключи.

NB:
* Если команда одна, то в поле `finders` вместо массива можно указать строку с этой командой.

### Секция parsers

В этой секции указываются пути до `парсеров` - модулей расширения, осуществляющих парсинг.

Названия полей - это суффиксы обрабатываемых парсером файлов. Суффиксом считается часть имени файла после первой точки.
Значения полей - это пути до модулей **парсеров**.


### Секция formatters

В этой секции указываются пути до **форматтеров** - модулей расширения,
осуществляющих преобразование массива ключей из внутреннего формата программы в формат, пригодный для отправки в Танкер.

Названия полей - это название формата. Использоваться будет формат, указанный в поле `tanker.push` конфига.
Значения полей - это пути до модулей **форматтеров**.


### Секция dispatchers

В этой секции указываются пути до `диспетчеров` - модулей расширения, преобразующих данные, пришедшие из танкера, к хешу вида путь-контент.

Названия полей - это название формата выгрузки. Использоваться будет формат, указанный в поле `tanker.pull` конфига.
Значения полей - это пути до модулей **диспетчеров**.


### Секция hinters

В этой секции указываются пути до `хинтеров` - модулей расширения, формирующих подсказки для интерактивного этапа резолвинга.

Названия полей - это тип ключа. По умолчанию выставляется парсером.
Значения полей - это пути до модулей расширения (**хинтеров**), формирующих варианты подсказок для различных полей ключа.
Подсказки отображаются на этапе интерактивного опроса пользователя.


### Секция resolving

В этой секции указываются настройки для этапа резолвинга данных.
Здесь описывается как интерпретировать те или иные поля [ключа](#-12).
Все поля имеют тип `{String[]}`, если иное не указано явно.

| Поле          | Описание                   | По умолчанию                                                                                 | Примечания |
|:--------------|:---------------------------|:---------------------------------------------------------------------------------------------|:-----------|
| `skip`        | Незначимые поля            | `["hash", "fragment", "range", , "type"]`                                                    | Поля не считаются значимыми при отправке в Танкер и не требуют уточнения пользователем при интерактивном опросе. |
| `vital`       | Критические поля           | `["upload", "language", "keyset", "key"]`                                                    | Если одно из таких полей принимает false-значение, дальнейшее уточнение данных ключа прекращается, а сам ключ не загружается в Танкер. |
| `common`      | Общие поля                 | `["upload", "single", "context"]`                                                            | Ключ с неполными данными, найденный в исходнике, может представлять собой несколько танкерных ключей. Здесь задаются поля, которые следует уточнить только один раз и продублировать во всех подключах. |
| `integrity`   | Признак целостности ключа  | `["single"]`                                                                                 | Поля, указывающие на соответствие фрагмента кода в исходном файле одному ключу в Танкере. |
| `plurality`   | Признак склоняемости ключа | `["plural"]`                                                                                 | Поля, указывающие на то, что ключ склоняемый. |
| `alwaysFresh` | Обновляемые поля           | `["location", "fragment", "range"]`                                                          | Набор полей, которые всегда актуализируются в карте ключей. |
| `alwaysTrust` | Доверенные поля            | `["path", "location", "fragment", "range"]`                                                  | Какое бы не было значение этих полей, оно считается верным, и никакие вопросы пользователю не задаются. |
| `neverTrust`  | Недоверенные поля          | `["keyset"]` (специфика BEM.I18N)                                                            | Поля, требующие обязательного уточнения у пользователя. |
| `order`       | Последовательность полей   | `["upload", "single", "language", "keyset",` `"key", "value", "comment", "context", "plural"]` | Порядок следования полей на этапе интерактивного опроса. |

NB:
* Из `alwaysTrust` всегда удаляются пересечения с `neverTrust`.


Ключ
----

**Ключ** - это хеш с данными о локализационном ключе, найденом в исходнике. Ключи создаются на этапе парсинга.

| Поле       | Описание                                                                                     | По умолчанию      | Тип          |
|:-----------|:---------------------------------------------------------------------------------------------|:------------------|:-------------|
| `upload`   | Определяет нужно ли загружать ключ в Танкер.                                                 | `null`            | `{Boolean}`  |
| `hash`     | ID ключа.                                                                                    | `null`            | `{String}`   |
| `path`     | Путь до файла, из которого был извлечен этот ключ.                                           | `null`            | `{String}`   |
| `location` | Индекс первого символа фрагмента кода в исходном файле. Задается в формате `строка:колонка`. | `null`            | `{String}`   |
| `range`    | Индексы первого и последнего символа фрагмента кода.                                         | `null`            | `{Number[]}` |
| `fragment` | Фрагмента исходного кода, соответствующий ключу.                                             | `null`            | `{String}`   |
| `single`   | Определяет соответствие фрагмента кода одному или нескольким реальным ключам.                | `null`            | `{Boolean}`  |
| `language` | Язык ключа.                                                                                  | `tanker.language` | `{String}`   |
| `keyset`   | Название кейсета.                                                                            | `null`            | `{String}`   |
| `key`      | Название ключа.                                                                              | `null`            | `{String}`   |
| `value`    | Значение ключа.                                                                              | `null`            | `{String}`   |
| `plural`   | Поле, определяющее склоняемость ключа.                                                       | `null`            | `{Boolean}`  |
| `comment`  | Комментарий для переводчиков.                                                                | `null`            | `{String}`   |
| `context`  | Контекст ключа для переводчиков.                                                             | `null`            | `{String}`   |
| `type`     | Тип ключа (выставляется парсером).                                                           | `null`            | `{String}`   |

**Важно**
* Ключ до резолвинга содержит данные, относящиеся к некоторому фрагменту кода. Этот фрагмент может соответствовать нескольким реальным танкерным ключам;
* ID ключа создается на основе фрагмента AST и пути до исходного файла. Перемещение этого фрагмента кода внутри файла или, к примеру, добавление в нем незначимого пробела на ID ключа не повлияет.


### Секция keysetAdapters

В этой секции указываются адаптеры для преобразования кейсетов во время [pull](#выгрузка-из-танкера) и [push](#отправка-в-танкер) операций, пример:

```js
module.exports = (config) => {
    config.keysetAdapters = {
        // Выполнится во время `tanker pull`
        pull: (keysets) => {
            return keysets;
        },
        // Выполнится во время `tanker push`
        push: ({ key, data }) => {
            return { key, data };
        },
    };
};
```

Модули расширения
-----------------

`TODO`


Консольный интерфейс
--------------------

Все действия производятся с помощью соответствующих подкоманд.

Во всех случаях аргумент `[path]` это фильтр-префикс.
С его помощью можно ограничить список файлов, с которыми будет работать программа,
т.е. можно сказать программе, что нужно работать только с ключами в конкретной директории или файле.
Кроме того, можно запускать команду из подкаталога, тогда  фильтр-префиксом будет путь до этого подкаталога.

| Команда                        | Описание                                                                                                |
|:-------------------------------|:--------------------------------------------------------------------------------------------------------|
| `tanker --help`                | Показать список подкоманд с кратким описанием.                                                          |
| `tanker conf [prop]`           | Показать весь конфиг или секцию `[prop]`.                                                               |
| `tanker find [path]`           | Показать результаты поиска, сформированные на основе секции `finders` в конфиге.                        |
| `tanker find --proc [path]`    | Показать только файлы для которых есть парсеры, указанные в секции `parsers` в конфиге.                 |
| `tanker find --keys [path]`    | Показать только файлы в которых найдены ключи.                                                          |
| `tanker keys [path]`           | Показать найденные ключи.                                                                               |
| `tanker keys --map [path]`     | По возможности показать данные из карты ключей, а не сырые данные от парсера.                           |
| `tanker push [path]`           | Отправить данные в Танкер.                                                                              |
| `tanker push --data [path]`    | Показать отправляемые данные, но ничего не отправлять.                                                  |
| `tanker pull`                  | Выгрузить данные из Танкера по ревизии `tanker.hash`.                                                   |
| `tanker pull --force`          | Выгрузить данные из Танкера по хеду ветки `tanker.branch`.                                              |
| `tanker pull [--force] --data` | Показать выгруженные данные, не раскладывая их по файловой системе.                                     |
| `tanker info [ref]`            | Показать информацию о текущей ревизии переводов или ревизии `[ref]` (может быть хеш или имя ветки).     |
| `tanker sync [path]`           | Синхронизировать переводы с Танкером.                                                                   |
| `tanker init`                  | Инициализация для новых проектов.                                                                       |
| `tanker about`                 | Показать версию программы и путь до текущего исполняемого файла.                                        |
| `tanker comp [options]`        | Показать варианты для автокомплита. Служебная команда. Использование в ручном режиме не предполагается. |

NB:
* Команды `tanker pull --force` и `tanker sync` после успешной раскладки данных по файловой системе, обновят файл `paths.tankerRef`, тем самым зафиксировав новую ревизию переводов;
* Из Танкера всегда выгружаются все данные переводов проекта. Встроенных средств для фильтрации данных, которые нужно обновить в проекте, нет, обновляется все.
