let _ = require('lodash');

function prependOAuth(token) {
    return 'OAuth ' + token;
}

module.exports = {

    '/history/': function(config) {
        return {
            url: 'https://' + config.host + '/history/',
            qs: {
                'project-id': config.project,
                ref: config.hash || config.branch,
                limit: config.limit,
                json: '',
            },
            method: 'GET',
            headers: {
                authorization: prependOAuth(config.token),
            },
        };
    },

    '/fhistory/': function(config) {
        return {
            url: 'https://' + config.host + '/fhistory/',
            qs: {
                'project-id': config.project,
                'branch-id': config.branch,
                limit: config.limit,
            },
            method: 'GET',
            headers: {
                authorization: prependOAuth(config.token),
            },
        };
    },

    '/admin/project/short-name/': function(config) {
        return {
            url: 'https://' + config.host + '/admin/project/' + config.project + '/',
            qs: {
                branch: config.hash || config.branch,
            },
            method: 'GET',
            headers: {
                authorization: prependOAuth(config.token),
            },
        };
    },

    '/admin/project/short-name/keysets/': function(config) {
        return {
            url: 'https://' + config.host + '/admin/project/' + config.project + '/keysets/',
            qs: {
                branch: config.hash || config.branch,
            },
            method: 'GET',
            headers: {
                authorization: prependOAuth(config.token),
            },
        };
    },

    '/projects/export/json/': function(config) {
        let result = {
            url: 'https://' + config.host + '/projects/export/json/',
            qs: {
                'project-id': config.project,
                'branch-id': config.hash || config.branch,
            },
            method: 'GET',
        };

        _.isString(config.status) && (result.qs.status = config.status);
        config.langs && (result.qs.language = String(config.langs));

        // Булевы параметры
        config.safe && (result.qs.safe = 'yes');
        config.flat && (result.qs['flat-keyset'] = 'yes');
        config.forms && (result.qs['all-forms'] = 'yes');

        return result;
    },

    '/projects/export/tjson/': function(config) {
        let result = {
            url: 'https://' + config.host + '/projects/export/tjson/',
            qs: {
                'project-id': config.project,
                'branch-id': config.hash || config.branch,
            },
            method: 'GET',
        };

        _.isString(config.status) && (result.qs.status = config.status);
        config.langs && (result.qs.language = String(config.langs));

        // Булевы параметры
        config.safe && (result.qs.safe = 'yes');
        config.forms && (result.qs['all-forms'] = 'yes');

        return result;
    },

    '/projects/export/po/': function(config) {
        let result = {
            url: 'https://' + config.host + '/projects/export/po/',
            qs: {
                'project-id': config.project,
                'branch-id': config.hash || config.branch,
            },
            method: 'GET',
        };

        _.isString(config.status) && (result.qs.status = config.status);
        config.langs && (result.qs.language = String(config.langs));

        // Булевы параметры
        config.safe && (result.qs.safe = 'yes');
        config.forms && (result.qs['all-forms'] = 'yes');

        return result;
    },

    '/projects/export/xml/': function(config) {
        let result = {
            url: 'https://' + config.host + '/projects/export/xml/',
            qs: {
                'project-id': config.project,
                'branch-id': config.hash || config.branch,
            },
            method: 'GET',
        };

        _.isString(config.status) && (result.qs.status = config.status);
        config.langs && (result.qs.language = String(config.langs));

        // Булевы параметры
        config.safe && (result.qs.safe = 'yes');
        config.forms && (result.qs['all-forms'] = 'yes');

        return result;
    },

    '/admin/project/short-name/keyset/': function(config) {
        return {
            url: 'https://' + config.host + '/admin/project/' + config.project + '/keyset/',
            qs: {
                branch: config.branch,
            },
            method: 'POST',
            headers: {
                authorization: prependOAuth(config.token),
            },
            body: JSON.stringify({ name: config.keyset }),
        };
    },

    '/keysets/create/': function(config) {
        return {
            url: 'https://' + config.host + '/keysets/create/',
            qs: {
                'branch-id': config.branch,
            },
            method: 'POST',
            headers: {
                'content-type': 'multipart/form-data',
                authorization: prependOAuth(config.token),
                expect: '',
            },
            multipart: [
                {
                    'content-disposition': 'form-data; name="file"; filename="data.json"',
                    body: config.file,
                },
                {
                    'content-disposition': 'form-data; name="project-id"',
                    body: config.project,
                },
                {
                    'content-disposition': 'form-data; name="keyset-id"',
                    body: config.keyset,
                },
                {
                    'content-disposition': 'form-data; name="format"',
                    body: config.push,
                },
            ],
        };
    },

    '/keysets/onlyadd/': function(config) {
        return {
            url: 'https://' + config.host + '/keysets/onlyadd/',
            qs: {
                'branch-id': config.branch,
            },
            method: 'POST',
            headers: {
                'content-type': 'multipart/form-data',
                authorization: prependOAuth(config.token),
                expect: '',
            },
            multipart: [
                {
                    'content-disposition': 'form-data; name="file"; filename="data.json"',
                    body: config.file,
                },
                {
                    'content-disposition': 'form-data; name="project-id"',
                    body: config.project,
                },
                {
                    'content-disposition': 'form-data; name="branch-id"',
                    body: config.branch,
                },
                {
                    'content-disposition': 'form-data; name="keyset-id"',
                    body: config.keyset,
                },
                {
                    'content-disposition': 'form-data; name="format"',
                    body: config.push,
                },
            ],
        };
    },
};
