module.exports = function(program) {
    (program)
        .command('comp')
        .description('Get posible completions for command')
        .option('-c, --cmd <command>', 'command')
        .option('-p, --pos <position>', 'index of the word under cursor')
        .option('--shell', 'shell code for profile (bash, zsh)')
        .action(function(env) {
            let oKeys = Object.keys;
            let cmd = env.cmd ? env.cmd.split(/ +/) : [];
            let pos = env.pos || (cmd.length - 1);
            let result = [];
            let tree = {};

            if (env.shell) {
                console.log(getProfileSnippet() || '# Only bash or zsh');
                process.exit(0);
            }

            program.commands.forEach(function(cmd) {
                let cmdNode = tree[cmd._name || ''] = {};

                cmd.options.forEach(function(opt) {
                    cmdNode[opt.long || ''] = {};
                });
            });

            switch (pos) {
                case '1':
                    result = oKeys(tree);
                    break;
                case '2':
                    var subcmd = cmd[1];

                    if (subcmd === 'conf') {
                        result = oKeys(require('../cnf'));
                    } else if (tree[subcmd]) {
                        result = oKeys(tree[subcmd]);
                    }
            }

            console.log(result.join('\n'));
        });
};

function getProfileSnippet() {
    let shell = (process.env.SHELL || '').split('/').pop();

    return Boolean(~['bash', 'zsh'].indexOf(shell)) && [
        '',
        '# tanker-kit completion. Use in conjunction with tanker-cli or global tanker-kit',
        '_tanker_completion() {',
        '    TANKERCOMP="$(tanker comp -c "${COMP_LINE}" -p "${COMP_CWORD}" 2> /dev/null)"',
        '    COMPREPLY=($(IFS=$\'\\n\' compgen -W "${TANKERCOMP}" -- "${COMP_WORDS[COMP_CWORD]}"))',
        '}',
        shell === 'zsh' ? 'autoload bashcompinit && bashcompinit' : '',
        'complete -o default -F _tanker_completion tanker',
        '# ------------------------------------------------------------------------------',
    ].join('\n');
}
