module.exports = function(program) {
    (program)
        .command('conf [prop]')
        .description('Show entire config, or config part')
        .action(function(prop) {
            let tanker = require('..');
            let print = tanker.util.print;

            tanker
                .config()
                .then(function(config) {
                    console.log(JSON.stringify(prop ? config[prop] : config, null, 4));
                    process.exit(0);
                })
                .fail(function(message) {
                    print.error(message.stack || message, 'Terminating');
                    process.exit(1);
                });
        });
};
