module.exports = function(program) {
    (program)
        .command('find [path]')
        .description('Show file search results')
        .option('-p, --proc', 'only files to process')
        .option('-k, --keys', 'only files with keys')
        .action(function(fprefix, env) {
            let path = require('path');
            let vow = require('vow');
            let tanker = require('..');
            let print = tanker.util.print;
            let needParse = env.proc || env.keys;
            let needBoth = env.proc && env.keys;

            tanker
                .config(function(config) {
                    config.paths.fprefix = path.join(process.cwd(), fprefix || '');
                })
                .then(function(config) {
                    return vow.all([
                        tanker.find(config),
                        config,
                    ]);
                })
                .spread(function(paths, config) {
                    return vow.all([
                        paths,
                        needParse && tanker.x.parse(paths, config),
                        config,
                    ]);
                })
                .spread(function(paths, parsing) {
                    if (env.proc) {
                        needBoth && print.info('Files to process:');
                        print.list(parsing.info.procPaths);
                    }
                    if (env.keys) {
                        needBoth && print.info('Files with keys:');
                        print.list(parsing.info.keysPaths);
                    }
                    if (!needParse) {
                        print.list(paths);
                    }

                    process.exit(0);
                })
                .fail(function(message) {
                    print.error(message.stack || message, 'Terminating');
                    process.exit(1);
                });
        });
};
