let program = require('commander');

require('./init')(program);
require('./conf')(program);
require('./find')(program);
require('./keys')(program);
require('./push')(program);
require('./pull')(program);
require('./sync')(program);
require('./info')(program);
require('./comp')(program);

program
    .command('about')
    .description('About info')
    .action(function() {
        let path = require('path');

        console.log('version: %s', require('../package').version);
        console.log('binpath: %s', path.relative(process.cwd(), require.resolve('../bin/tanker')));
    });

program.parse(process.argv);
