module.exports = function(program) {
    (program)
        .command('info [ref]')
        .description('Ref info')
        .action(function(hash) {
            let assert = require('assert');
            let _ = require('lodash');
            let vow = require('vow');
            let tanker = require('..');
            let api = require('../api');
            let print = tanker.util.print;

            tanker
                .config()
                .then(function(config) {
                    hash || (hash = config.tanker.hash);

                    assert(hash, 'Current translations not linked with revision');

                    return vow.all([
                        api.resource('/history/', config.tanker, {
                            limit: 1,
                            hash: hash,
                        }),
                        config,
                    ]);
                })
                .spread(function(data) {
                    print.json(_.pick(data.commits[0], ['sha1', 'author', 'date', 'message']));
                    process.exit(0);
                })
                .fail(function(message) {
                    print.error(message.stack || message, 'Terminating');
                    process.exit(1);
                });
        });
};
