module.exports = function(program) {
    (program)
        .command('keys [path]')
        .description('Show keys')
        .option('-m, --map', 'show resolved data if possible')
        .action(function(fprefix, env) {
            let assert = require('assert');
            let path = require('path');
            let _ = require('lodash');
            let vow = require('vow');
            let tanker = require('..');
            let print = tanker.util.print;
            let saferequire = tanker.util.saferequire;

            require('colors');

            tanker
                .config(function(config) {
                    config.paths.fprefix = path.join(process.cwd(), fprefix || '');
                })
                .then(function(config) {
                    return vow.all([tanker.find(config), config]);
                })
                .spread(function(paths, config) {
                    return vow.all([tanker.parse(paths, config), config]);
                })
                .spread(function(keys, config) {
                    assert(keys.length, 'Nothing Found');

                    let map = saferequire(config.paths.tankerMap) || {};
                    let result = {};
                    let unresolved = {};

                    if (env.map) {
                        keys.forEach(function(key) {
                            if (map[key.hash]) {
                                result[key.hash] = map[key.hash];
                            } else {
                                result[key.hash] = (result[key.hash] || []).concat(key);
                                unresolved[key.hash] = true;
                            }
                        });
                    } else {
                        result = _.groupBy(keys, 'hash');
                    }

                    result = JSON.stringify(result, null, 4);

                    Object.keys(unresolved).forEach(function(hash) {
                        result = result.replace('"' + hash + '":', '"' + hash.red + '":');
                    });

                    process.stdout.write(result + '\n', function() {
                        process.exit(0);
                    });
                })
                .fail(function(message) {
                    print.error(message.stack || message, 'Terminating');
                    process.exit(1);
                });
        });
};
