module.exports = function(program) {
    (program)
        .command('pull')
        .description('Download project data from Tanker')
        .option('-d, --data', 'show data, don\'t change files')
        .option('-f, --force', 'get latest data (ignore ref)')
        .action(function(env) {
            let fs = require('fs');
            let vow = require('vow');
            let tanker = require('..');
            let print = tanker.util.print;

            tanker
                .config(function(config) {
                    config.tanker.force = Boolean(env.force);
                })
                .then(function(config) {
                    return vow.all([
                        tanker.x.pull(config),
                        config,
                    ]);
                })
                .spread(function(downloading, config) {
                    if (env.data) {
                        print.info('Data from Tanker:');
                        print.pretty(downloading.data);
                        process.exit(0);
                    }

                    return vow.all([
                        downloading,
                        tanker.dispatch(downloading.data, config),
                        config,
                    ]);
                })
                .spread(function(downloading, status, config) {
                    let pullHash = downloading.meta.hash;

                    print.info('Success');

                    if (config.tanker.hash !== pullHash.sha1) {
                        fs.writeFileSync(config.paths.tankerRef, JSON.stringify(pullHash, null, 4));
                        print.info('Revision has been saved in ' + config.paths.tankerRef);
                    }

                    process.exit(0);
                })
                .fail(function(message) {
                    print.error(message.stack || message, 'Terminating');
                    process.exit(1);
                });
        });
};
