module.exports = function(program) {
    (program)
        .command('push [path]')
        .description('Send project data to Tanker')
        .option('-d, --data', 'show data, don\'t send anything')
        .action(function(fprefix, env) {
            let path = require('path');
            let vow = require('vow');
            let tanker = require('..');
            let NoError = tanker.util.NoError;
            let print = tanker.util.print;

            tanker
                .config(function(config) {
                    config.paths.fprefix = path.join(process.cwd(), fprefix || '');
                })
                .then(function(config) {
                    return vow.all([
                        tanker.find(config),
                        config,
                    ]);
                })
                .spread(function(paths, config) {
                    return vow.all([
                        tanker.parse(paths, config),
                        config,
                    ]);
                })
                .spread(function(keys, config) {
                    return vow.all([
                        tanker.resolve(keys, config),
                        config,
                    ]);
                })
                .spread(function(keys, config) {
                    return vow.all([
                        keys,
                        tanker.format(keys, config),
                        config,
                    ]);
                })
                .spread(function(keys, data, config) {
                    if (env.data) {
                        print.info('Data for upload:');
                        print.pretty(data);
                        process.exit(0);
                    }

                    return tanker.push(keys, data, config);
                })
                .then(function() {
                    print.info('Data has been sent.');
                    process.exit(0);
                })
                .fail(function(error) {
                    if (error instanceof NoError) {
                        print.info(error.message);
                        process.exit(0);
                    } else {
                        print.error(error.stack || error, 'Terminating');
                        process.exit(1);
                    }
                });
        });
};
