module.exports = function(program) {
    (program)
        .command('sync [path]')
        .description('Sync data with Tanker')
        .action(function(fprefix) {
            let assert = require('assert');
            let path = require('path');
            let fs = require('fs');
            let vow = require('vow');
            let tanker = require('..');
            let print = tanker.util.print;

            tanker
                .config(function(config) {
                    config.paths.fprefix = path.join(process.cwd(), fprefix || '');
                    config.tanker.force = true;
                })
                .then(function(config) {
                    return vow.all([
                        tanker.find(config),
                        config,
                    ]);
                })
                .spread(function(paths, config) {
                    assert(paths.length, 'No files were found');

                    return vow.all([
                        tanker.parse(paths, config),
                        config,
                    ]);
                })
                .spread(function(keys, config) {
                    assert(keys.length, 'Nothing Found');

                    return vow.all([
                        tanker.resolve(keys, config),
                        config,
                    ]);
                })
                .spread(function(keys, config) {
                    assert(keys.length, 'No keys requires upload');

                    return vow.all([
                        keys,
                        tanker.format(keys, config),
                        config,
                    ]);
                })
                .spread(function(keys, data, config) {
                    return vow.all([
                        tanker.push(keys, data, config),
                        config,
                    ]);
                })
                .spread(function(response, config) {
                    return vow.all([
                        tanker.x.pull(config),
                        config,
                    ]);
                })
                .spread(function(downloading, config) {
                    return vow.all([
                        downloading,
                        tanker.dispatch(downloading.data, config),
                        config,
                    ]);
                })
                .spread(function(downloading, status, config) {
                    let pullHash = downloading.meta.hash;

                    print.info('Success');

                    if (config.tanker.hash !== pullHash.sha1) {
                        fs.writeFileSync(config.paths.tankerRef, JSON.stringify(pullHash, null, 4));
                        print.info('Revision has been saved in ' + config.paths.tankerRef);
                    }

                    process.exit(0);
                })
                .fail(function(message) {
                    print.error(message.stack || message, 'Terminating');
                    process.exit(1);
                });
        });
};
