module.exports = function() {
    const parserBem = require.resolve('../ext/parsers/bem');

    return {
        paths: {
            root: null,
            fprefix: null,
            tankerDir: null,
            tankerCnf: null,
            tankerRsl: null,
            tankerRef: null,
            tankerMap: null,
            tankerLog: null,
        },

        tanker: {
            host: 'tanker-api.yandex-team.ru',
            project: null,
            token: null,
            branch: 'master',
            hash: null,
            original: 'ru',
            langs: null,
            status: null,
            safe: true,
            flat: true,
            forms: true,
            push: 'tjson',
            pull: 'json',
            force: false,
        },

        finders: [],

        parsers: {
            js: parserBem,
            'priv.js': parserBem,
            bemhtml: parserBem,
            'bemhtml.js': parserBem,
            'bh.js': parserBem,
            'bemjson.js': parserBem,
        },

        formatters: {
            tjson: require.resolve('../ext/formatters/tjson'),
        },

        dispatchers: {
            json: require.resolve('../ext/dispatchers/json2bem'),
        },

        hinters: {
            bem: require.resolve('../ext/hinters/bem'),
        },

        resolving: {
            skip: ['hash', 'fragment', 'range', 'type', 'params'],
            vital: ['upload', 'language', 'keyset', 'key'],
            common: ['upload', 'single'],
            integrity: ['single'],
            plurality: ['plural'],
            alwaysFresh: ['location', 'fragment', 'range'],
            alwaysTrust: ['path', 'location'],
            neverTrust: ['keyset'],
            order: ['upload', 'single', 'language', 'keyset', 'key', 'value', 'comment', 'context', 'plural'],
        },

        keysetAdapters: {},
    };
};
