let path = require('path');
let assert = require('assert');
let _ = require('lodash');
let keys = Object.keys;
let tmpl = _.template('module.exports = ${ data };\n');

module.exports = function(arg) {
    let json = JSON.parse(arg.data);
    let langs = keys(json);
    let result = {};

    langs.forEach(function(lang) {
        let keysets = keys(json[lang]);

        keysets.forEach(function(keyset) {
            let bemKey = keyset.split(':').pop();
            let keysetPath = getPathByKeyset(keyset, lang);
            let keysetData = {};

            keysetData[bemKey] = json[lang][keyset];
            result[keysetPath] = tmpl({ data: JSON.stringify(keysetData, null, 4) });
        });
    });

    return result;
};

function getPathByKeyset(keyset, lang) {
    let re = /^([^_]+)(__[^_]+)?(?:(_[^_]+)(_[^_]+))?$/;
    let parts = keyset.split(':');
    let levels = parts.slice(0, -1);
    let bemKey = parts.slice(-1)[0];
    let bemv = (bemKey.match(re) || []).slice(1).map(function(item) { return item || '' });

    assert(bemv.length, 'Некорректное имя кейсета (' + keyset + ')');

    return path.normalize(
        (levels)
            .concat(bemv.slice(0, 3))
            .concat(bemKey + '.i18n')
            .concat(lang + '.js')
            .join(path.sep)
    );
}
