let vm = require('vm');
let fs = require('fs');
let path = require('path');
let _ = require('lodash');
let tmpl = fs.readFileSync(path.join(__dirname, 'tjson.tmpl'), 'utf8');

module.exports = function(arg) {
    let code = _.template(tmpl, rollOut(arg.data, 'keyset.key.language'), { variable: 'keysets' });
    let data = vm.runInThisContext(code);

    return JSON.stringify(data, null, 4);
};

/**
 * Принимает массив однотипных хешей.
 * Разворачивает их в объект с заданной структурой вложенности.
 *
 * Пример:
 * rollOut([
 *     { category: 'fruit',     name: 'orange', total: 3, price: 17.5, comment: 'very tasty' },
 *     { category: 'fruit',     name: 'apple',  total: 5, price: 12 },
 *     { category: 'vegetable', name: 'potato', total: 1, price: 8  }
 * ], 'category.name');
 *
 * // {
 * //     "fruit": {
 * //         "orange": {
 * //             "total": 3,
 * //             "price": 17.5,
 * //             "comment": "very tasty"
 * //         },
 * //         "apple": {
 * //             "total": 5,
 * //             "price": 12
 * //         }
 * //      },
 * //      "vegetable": {
 * //          "potato": {
 * //              "total": 1,
 * //              "price": 8
 * //          }
 * //      }
 * // }
 *
 * @param {Object[]} array Массив однотипных хешей
 * @param {String} chain Иерархия. Звенья разделяются точкой
 * @returns {Object}
 */
function rollOut(array, chain) {
    chain = chain.split('.');

    return array.reduce(function(rslt, item) {
        let tail = chain.reduce(function(rslt, key) {
            return rslt[item[key]] || (rslt[item[key]] = {});
        }, rslt);

        _.extend(tail, _.omit(item, chain));

        return rslt;
    }, {});
}
