let path = require('path');
let _ = require('lodash');

module.exports = function(arg) {
    let key = arg.data;
    let keyset = key.keyset;
    let bemItemByKey = getBemItemByKey(keyset);
    let bemItemByPath = getBemItemByPath(key.path);
    let assumptions = Object.keys(key).reduce(function(result, key) {
        result[key] = [];
        return result;
    }, {});

    if (bemItemByKey.block === bemItemByPath.block) {
        assumptions.keyset.push(bemItemByPath.level.concat(keyset).join(':'));
    }

    assumptions.keyset = _(assumptions.keyset).uniq().difference([keyset]).value();

    return assumptions;
};

function getBemItemByKey(bemKey) {
    let bemv = (bemKey || '').match(/^([^_]+)(__[^_]+)?(?:(_[^_]+)(_[^_]+))?$/) || [];

    return {
        block: bemv[1] || '',
        elem: bemv[2] || '',
        mod: bemv[3] || '',
        val: bemv[4] || '',
    };
}

function getBemItemByPath(filePath) {
    let dirs = path.dirname(filePath).split(path.sep).reverse();
    let bemItem = {
        level: [],
        block: '',
        elem: '',
        mod: '',
    };

    dirs.forEach(function(dir) {
        if (/^_[^_]+/.test(dir)) {
            bemItem.mod = dir.split('_')[1];
        } else if (/^__[^_]+/.test(dir)) {
            bemItem.elem = dir.split('__')[1];
        } else if (/^[^_]+$/.test(dir) && !bemItem.block) {
            bemItem.block = dir;
        } else {
            bemItem.level.unshift(dir);
        }
    });

    return bemItem;
}
