let jsParser = require('./bem/javascript');
let bemhtmlParser = require('./bem/bemhtml');
let bemjsonParser = require('./bem/bemjson');
let parsers = {
    js: jsParser,
    'priv.js': jsParser,
    'bh.js': jsParser,
    'vanilla.js': jsParser,
    'bemhtml.js': jsParser,
    bemhtml: bemhtmlParser,
    'bemjson.js': bemjsonParser,
};

module.exports = function(arg) {
    return parsers[arg.type] ? parsers[arg.type](arg) : [];
};
