let _ = require('lodash');
let espree = require('espree');
let util = require('../../lib/util');
let getNested = util.getNested;
let walkAndInvoke = util.walkAndInvoke;
let getHash = util.getHash;
let substring = String.prototype.substring;
let isArray = Array.isArray;
let isString = _.isString;
let LIGHT_CHECK = /['"]?elem['"]?\s*:\s*['"]i18n['"]/;

module.exports = function(arg) {
    if (!LIGHT_CHECK.test(arg.data)) {
        return [];
    }

    let content = arg.data;
    let filePath = arg.path;
    let ast = espree.parse(content, {
        range: true,
        loc: true,
        ecmaVersion: 2018,
    });
    let result = [];

    walkAndInvoke(ast, ['type', 'ObjectExpression'], function(node) {
        let fragment = substring.apply(content, node.range);
        let location = getNested(node, 'loc.start');
        let props = {};

        node.properties.forEach(function(prop) {
            let name = getNested(prop, 'key.name|value');
            let value = getNested(prop, 'value.value|elements');

            name && (props[name] = value);
        });

        let isItKey = (props.block === 'i-bem') && (props.elem === 'i18n');

        // Склоняемый
        if (isArray(props.value)) {
            props.value.length = 4;
            props.value = props.value.map(function(item) {
                return item.value || null;
            });
        }

        isItKey && result.push({
            type: 'bem',
            hash: getHash(node, filePath),
            path: filePath,
            fragment: fragment,
            range: node.range,
            location: [location.line, location.column],
            upload: null,
            single: (isString(props.keyset) && isString(props.key)) || null,
            keyset: isString(props.keyset) ? props.keyset : null,
            key: isString(props.key) ? props.key : null,
            value: isString(props.value) || isArray(props.value) ? props.value : null,
            comment: isString(props.comment) ? props.comment : null,
            context: isString(props.context) ? props.context : null,
            plural: isArray(props.value) ? true : isString(props.value) ? false : null,
            params: props.params || false,
        });
    });

    return result;
};
