let _ = require('lodash');
let espree = require('espree');
let util = require('../../lib/util');
let getNested = util.getNested;
let walkAndInvoke = util.walkAndInvoke;
let getHash = util.getHash;
let substring = String.prototype.substring;
let isString = _.isString;
let isArray = _.isArray;
let LIGHT_CHECK = /(?:BEM(?:(?:\.I18N)|(?:\[['"]I18N['"]\])))|(?:i18n[.\[])|(?:I18N\()/;

module.exports = function(arg) {
    if (!LIGHT_CHECK.test(arg.data)) {
        return [];
    }

    let content = arg.data;
    let filePath = arg.path;
    let ast = espree.parse(content, {
        range: true,
        loc: true,
        ecmaVersion: 2018,
        sourceType: 'module',
        ecmaFeatures: {
            jsx: true,
        },
    });
    let result = [];

    walkAndInvoke(ast, ['type', 'CallExpression'], function(node) {
        let nested = getNested.bind(null, node);
        let checkNode = checkConditions.bind(null, nested);
        let fragment = substring.apply(content, node.range);
        let location = nested('loc.start');
        let keyset;
        let key;
        let params;

        if (checkNode(
            // BEM.I18N('keyset', 'key', params)
            ['callee.object.name', 'BEM'],
            ['callee.property.name|value', 'I18N']
        )) {
            keyset = nested('arguments.0.value');
            key = nested('arguments.1.value');
            params = nested('arguments.2.properties');
        } else if (checkNode(
            // BEM.I18N.key('key', params)
            ['callee.object.object.name', 'BEM'],
            ['callee.object.property.name|value', 'I18N'],
            ['callee.property.name|value', 'key']
        )) {
            key = nested('arguments.0.value');
            params = nested('arguments.1.properties');
        } else if (checkNode(
            // i18n['prj']['keyset']['key'](params)
            ['callee.object.object.object.name', 'i18n']
        )) {
            keyset = nested('callee.object.property.name|value');
            key = nested('callee.property.name|value');
            params = nested('arguments.0.properties');
        } else if (checkNode(
            ['callee.type', 'Identifier'],
            ['callee.name', 'I18N']
        )) {
            keyset = nested('arguments.0.value');
            key = nested('arguments.1.value');
            params = nested('arguments.2.properties');
        } else {
            return;
        }

        params = !isArray(params) ? false : params.reduce(function(obj, item) {
            obj[getNested(item, 'key.name')] = getNested(item, 'value.value');
            return obj;
        }, {});

        result.push({
            type: 'bem',
            hash: getHash(node, filePath),
            path: filePath,
            fragment: fragment,
            range: node.range,
            location: [location.line, location.column],
            upload: null,
            single: (isString(keyset) && isString(key)) || null,
            keyset: isString(keyset) ? keyset : null,
            key: isString(key) ? key : null,
            value: null,
            comment: null,
            context: null,
            plural: null,
            params: params,
        });
    });

    return result;
};

function checkConditions(getValue, assertions) {
    assertions = [].slice.call(arguments, 1);

    return assertions.every(function(assertion) {
        return getValue(assertion[0]) === assertion[1];
    });
}
