let _ = require('lodash');
let vow = require('vow');

/**
 * Формирует конфиг.
 *
 * @param {Function} [corrections] Коррекции для базового конфига
 *
 * @returns {Promise} result
 * @returns {Object}  result.data Конфиг
 */
module.exports = function(corrections) {
    let config = require('../cnf')();
    let runtime = require('../cnf/runtime.js');

    return vow
        .invoke(function() {
            return corrections && corrections(config);
        })
        .then(function() {
            return runtime(config);
        })
        .then(function() {
            return require(config.paths.tankerCnf)(config);
        })
        .then(function() {
            return {
                info: {},
                meta: {},
                data: makeSugarFree(config),
            };
        });
};

/**
 * Убирает сахар и неоднозначности.
 */
function makeSugarFree(config) {
    // 'test' -> 'tanker-api.test.yandex-team.ru'
    config.tanker.host === 'test' && (config.tanker.host = 'tanker-api.test.yandex-team.ru');

    // 'command' -> [command]
    config.finders = [].concat(config.finders);

    // alwaysTrust и neverTrust не должны пересекаться. neverTrust круче.
    config.resolving.alwaysTrust = _.difference(
        config.resolving.alwaysTrust, config.resolving.neverTrust);

    return config;
}
