let assert = require('assert');
let path = require('path');
let _ = require('lodash');
let vow = require('vow');
let vowfs = require('vow-fs');

/**
 * Раскладывает данные по файловой системе.
 *
 * @param {String} data Танкерные данные
 * @param {Object} config Конфиг
 *
 * @returns {Promise} result
 * @returns {Boolean} result.data Флаг об успешности завершения операции
 */
module.exports = function(data, config) {
    config.logger('dispatch.startTime', new Date());

    let format = config.tanker.pull;
    let dispatcherPath = config.dispatchers[format];

    assert(dispatcherPath, 'Не указан диспетчер для формата ' + format);

    return vow
        .invoke(function() {
            return require(dispatcherPath)({
                info: {
                    config: config,
                },
                data: data,
            });
        })
        .then(function(dispatchMap) {
            return vow.all(_.map(dispatchMap, function(content, filePath) {
                filePath = path.resolve(config.paths.root, filePath);

                return vowfs
                    .makeDir(path.dirname(filePath))
                    .then(function() {
                        return vowfs.write(filePath, content, 'utf8');
                    });
            }));
        })
        .then(function() {
            config.logger('dispatch.finishTime', new Date());
            return {
                info: {},
                meta: {},
                data: true,
            };
        });
};
