let assert = require('assert');
let path = require('path');
let exec = require('child_process').exec;
let _ = require('lodash');
let vow = require('vow');
let print = require('./util').print;
let FIND_EXEC_BUFFER_SIZE = process.env.FIND_EXEC_BUFFER_SIZE || 1048576;

/**
 * Выполняет команды для поиска файлов, фильтрует результаты,
 * разворачивает пути в абсолютные, склеивает, удаляет дубли.
 *
 * @param {Object} config Конфиг
 *
 * @returns {Promise}  result
 * @returns {String[]} result.data Абсолютные пути
 */
module.exports = function(config) {
    config.logger('find.startTime', new Date());

    assert(config.finders.length, 'Не переданы команды для поиска файлов');

    let root = config.paths.root;
    let absolute = path.resolve.bind(path, root);
    let fprefix = config.paths.fprefix;
    let results = [];

    config.finders.forEach(function(command) {
        let promise = new vow.Promise(function(resolve) {
            exec(command, { cwd: root, maxBuffer: FIND_EXEC_BUFFER_SIZE }, function(error, stdout) {
                let result = [];

                if (error !== null) {
                    print.error('Не удалось выполнить команду: ' + command);
                } else {
                    stdout.trim().split('\n').forEach(function(filePath) {
                        filePath = absolute(filePath);
                        filePath.indexOf(fprefix) === 0 && result.push(filePath);
                    });
                }

                resolve(result);
            });
        });

        results.push(promise);
    });

    return vow
        .all(results)
        .then(function(args) {
            return _(args).flatten().uniq().value();
        })
        .then(function(paths) {
            config.logger('find.finishTime', new Date());
            return {
                info: {},
                meta: {},
                data: paths,
            };
        });
};
