let assert = require('assert');
let vow = require('vow');

/**
 * Преобразует массив ключей в формат, пригодный для отправки в Танкер.
 *
 * @param {Object[]} keys Ключи
 * @param {Object}   config Конфиг
 *
 * @returns {Promise} result
 * @returns {String}  result.data Данные
 */
module.exports = function(keys, config) {
    config.logger('format.startTime', new Date());

    let format = config.tanker.push;
    let formatterPath = config.formatters[format];

    assert(formatterPath, 'Не указан форматтер для ' + format);

    return vow
        .resolve(require(formatterPath)({ data: keys }))
        .then(function(data) {
            config.logger('format.finishTime', new Date());
            return {
                info: {},
                meta: {},
                data: data,
            };
        });
};
