/*
 * У всех модулей формат возвращаемого значения { info: {}, meta: {}, data: {} }
 * Как правило info и meta внешнему коду не нужны, поэтому прямые ссылки на модули
 * хранятся в специальном объекте x (от слова extended), а непосредственно в exports
 * кладутся обертки над модулями, которые вернут только свойство data.
 */

// Прямые ссылки на модули
exports.x = {
    config: require('./config'),
    find: require('./find'),
    parse: require('./parse'),
    resolve: require('./resolve'),
    format: require('./format'),
    push: require('./push'),
    pull: require('./pull'),
    dispatch: require('./dispatch'),
};

// Обертки над модулями, которые возвращают только свойство data
Object.keys(exports.x).forEach(function(key) {
    exports[key] = function() {
        return exports.x[key].apply(null, arguments).then(function(result) {
            return result.data;
        });
    };
});

// Функции общего назначения
exports.util = require('./util');
