let _ = require('lodash');
let vow = require('vow');
let api = require('../api');

/**
 * Выкачивает переводы из Танкера.
 *
 * @param {Object} config Конфиг
 *
 * @returns {Promise} result
 * @returns {Object}  result.meta
 * @returns {Object}  result.meta.hash Информация о ревизии
 * @returns {String}  result.data Данные, которые вернул Танкер
 */
module.exports = function(config) {
    config.logger('pull.startTime', new Date());

    let isForce = config.tanker.force || !config.tanker.hash;

    return vow.invoke(function() {
        return isForce ? api.head(config.tanker) : config.tanker.hash;
    })
        .then(function(hash) {
            return vow.all([
                api.export(config.tanker, hash),
                api.resource('/history/', config.tanker, {
                    limit: 1,
                    hash: hash,
                }),
            ]);
        })
        .spread(function(data, hash) {
            if (config.keysetAdapters.pull !== undefined) {
                let parsedData = JSON.parse(data);
                let processedData = config.keysetAdapters.pull(parsedData);
                data = JSON.stringify(processedData);
            }

            return vow.all([data, hash]);
        })
        .spread(function(data, hash) {
            config.logger('pull.hash', _.pick(hash.commits[0], ['sha1', 'date']));
            config.logger('pull.finishTime', new Date());
            return {
                info: {},
                meta: {
                    hash: _.pick(hash.commits[0], ['sha1', 'date']),
                },
                data: data,
            };
        });
};
