export function create(settings?: IWoofSettings): IServerInstance;

interface IServerInstance {
    /**
     * Метод для генерации HTML, который нужно инициализировать из md
     *
     * @param text - Markdown документ с вики-разметкой
     * @param settings - Дополнительные параметры рендеринга
     */
    renderToString(text: string, settings?: IWoofSettings): Promise<string>;

    /**
     * Метод для получения кода браузерного форматтера
     */
    getBrowserCode(): IBrowserCode;
}

interface IBrowserCode {
    /**
     * Url css бандла нужной версии
     */
    cssUrl: string;

    /**
     * Url js бандла нужной версии
     */
    jsUrl: string;

    /**
     * Дополнительный js код, который нужно встроить инлайново
     */
    jsConfigurationCode: string;
}

interface IWoofSettings {
    /**
    * Инстанс.
    * default: 'intranet'
    */
    instance?: 'intranet' | 'business';

    /**
     * Платформа.
     * default: 'desktop'
     */
    platform?: 'desktop' | 'touch';

    /**
     * Язык интерфейса.
     * default: 'ru'
     */
    lang?: 'ru' | 'en';

    /**
     * Тема, для подсветки блоков кода.
     * default: 'github'
     */
    code_theme?: 'dark' | 'solarized_dark' | 'solarized_light' | 'idea' | 'github';

    /**
     * Хост магичекских ссылок.
     * default: 'https://wf.yandex-team.ru/magiclinks/v1/links'
     */
    magiclinks_url?: string;

    /**
     * Ссылка на Трекер.
     * default: 'https://st.yandex-team.ru'
     */
    tracker_url?: string;

    /**
     * Ссылка на Стафф.
     * default: 'https://staff.yandex-team.ru'
     */
    staff_url?: string;

    /**
     * Ссылка на бэкенд для экшенов.
     * default: 'https://schi.yandex-team.ru'
     */
    schi_url?: string;

    /**
     * Ссылка на Этушку
     * default: 'https://clubs.at.yandex-team.ru'
     */
    at_url?: string;

    /**
     * Ссылка на Конструктор форм.
     * default: 'https://forms.yandex-team.ru'
     */
    forms_url: string;

    /**
     * Ссылка на Вики.
     * default: 'https://wiki.yandex-team.ru'
     */
    wiki_url: string;

    /**
     * Ссылка на АПИ Вики.
     * default: 'https://wiki-api.yandex-team.ru'
     */
    wiki_api_url: string;

    /**
     * Ссылка на Docviewer.
     * default: 'https://docviewer.yandex-team.ru'
     */
    docviewer_url: string;

    /**
     * Ссылка на Charts.
     * default: 'https://charts-beta.yandex-team.ru'
     */
    charts_url: string;

    /**
     * Ссылка на Statface.
     * default: 'https://stat-beta.yandex-team.ru'
     */
    statface_url: string;

    /**
     * Ссылка на статику.
     * default: 'https://yastatic.net'
     */
    yastatic_url: string;

    /**
     * Насторойки для парсера `remark`
     */
    remark?: IRemarkSettings;
}

interface IRemarkSettings {
    /**
     * Настройки для плагина `remark-woofmd`
     */
    woofmd: {
        actions: IAction[];
    };
}

interface IAction {
    /**
     * Название экшена
     */
    name: string;
}
