import { IWoofSettings } from '../server';

interface IFormatterViewportParams {
    domElem: HTMLElement;
    settings?: IWoofSettings
}

declare class FormatterViewPort {
    /**
     * Создает инстанс браузерного форматтера
     * */
    constructor(params: IFormatterViewportParams);

    /**
     * Рендерит wiki-разметку внутри IFormatterViewportParams.domElem
     *
     * @param source - Wiki-разметка
     * @param [params] - Дополнительные параметры
     * */
    render(source: string, params?: IWoofSettings): Promise<void>;

    /**
     * Рендерит wiki-разметку в html, и возвращает строку
     *
     * @param source - Wiki-разметка
     * @param [params] - Дополнительные параметры
     *
     * @returns Результирующий html
     * */
    renderToString(source: string, params?: IWoofSettings): Promise<string>;

    /**
     * Удаляет отрендеренный Wiki-DOM
     * */
    remove(): Promise<void>;
}

export as namespace Ya;
