const createI18N = (translations, lang) => {
    const _translation = Object.assign({}, translations, { '@@meta@@': { lang } });

    const f = (keyset, key, params) => {
        if (!_translation[keyset] || !_translation[keyset][key]) {
            return `:${keyset}:${key}`;
        }
        const translate = _translation[keyset][key];

        return typeof translate === 'function' ? translate(params) : translate;
    };

    f.lang = () => {
        return f('@@meta@@', 'lang');
    };

    return f;
};

module.exports = createI18N;
