const merge = require('lodash/merge');
const translations = require('./translations');

const defaults = {
    lang: 'ru',
    platform: 'desktop',
    instance: 'intranet',

    schi_url: 'https://schi.yandex-team.ru',
    magiclinks_url: 'https://wf.yandex-team.ru/magiclinks/v1/links',
    tracker_url: 'https://st.yandex-team.ru',
    staff_url: 'https://staff.yandex-team.ru',
    forms_url: 'https://forms.yandex-team.ru',
    wiki_url: 'https://wiki.yandex-team.ru',
    wiki_api_url: 'https://wiki-api.yandex-team.ru',
    docviewer_url: 'https://docviewer.yandex-team.ru',
    at_url: 'https://clubs.at.yandex-team.ru',
    charts_url: 'https://charts-beta.yandex-team.ru',
    statface_url: 'https://stat-beta.yandex-team.ru',
    yastatic_url: 'https://yastatic.net',

    useAJAX: false,
    renderActionsByClick: false,

    code_theme: 'github',
    page_path: '',

    remark: {
        markdown: {
            commonmark: true,
            footnotes: true,
            position: true,
        },
        woofmd: {
            actions: [
                {
                    name: 'toc',
                },
            ],
        },
    },
};

function getSettings(...args) {
    const settings = merge({}, defaults, ...args);

    Object.assign(settings, {
        translations: translations[settings.lang],
    });

    return settings;
}

exports.getSettings = getSettings;
