module.exports = {
    en: {
        'wiki-action-include': {
            error_403: function(p) { return 'You do not have access to ' + (p && p.content || '?') + '.' },
            error_404: function(p) { return 'The page ' + (p && p.content || '?') + ' does not exist.' },
            cycle: 'The cyclic dependence is found',
            page: 'Page',
            grid: 'Page-grid is inserted into the page through the action {{grid}}',
        },

        'wiki-formatter': {
            error: function(p) { return 'Rendering error ' + (p && p.formatter || '?') + '.' },
        },

        'wiki-action-serviceteam': {
            contacts: 'Service contacts',
            roles: 'Service team',
            serviceteam: 'Service team',
        },

        'wiki-action-mywatches': {
            unwatch: 'Unsubscribe from changes',
        },

        'wiki-action-backlinks': {
            backlinks: 'Pages that link to this page',
            backlinks_for: function(p) { return 'Pages that link to ' + (p && p.content || '?') },
        },

        'wiki-action-mypages': {
            user_pages: 'Pages of',
            ordered: 'ordered',
        },

        'wiki-action-tasks': {
            'no-tasks': 'Tickets for this request were not found.',
        },

        'wiki-action': {
            error: 'Failed to get action',
            not_implemented: function(p) { return 'Action ' + (p && p.action || '') + ' not yet implemented.' },
            error_args_not_found: function(p) { return 'Failed to get action ' + (p && p.action || '') + '. Arguments not found: ' + (p && p.args || '') + '.' },
            error_unauthorized: function(p) { return 'Failed to get action ' + (p && p.action || '') + '. Authorization error.' },
            error_wiki_api: function(p) { return 'Failed to get action ' + (p && p.action || '') + '. ' + (p && p.error || '') },
            load: 'Load',
            action: 'Action',
            error_any: function(p) { return 'Error while getting ' + (p && p.content || '?') },
        },

        'wiki-widget-action': {
            error: 'Failed to get action',
        },

        'wiki-action-tree': {
            cluster_tree: 'Cluster tree',
            expand_all: 'Show all subpagess',
            full_loaded: 'All subpages loaded',
            not_full_loaded: 'Not all subpages are loaded',
            expand_all_error: 'Failed to load whole tree!',
        },

        'wiki-action-tree-page': {
            created: 'created',
            modified: 'edited',
        },

        'wiki-action-feed': {
            today: 'today',
        },

        'wiki-head': {
            edit: 'edit',
        },

        'wiki-toc': {
            contents: 'Contents',
        },

        'wiki-ref': {
            external_link: 'External link (opens in new window)',
        },

        'wiki-cut': {
            more: 'More',
        },
    },

    ru: {
        'wiki-action-include': {
            error_403: function(p) { return 'У вас нет доступа к ' + (p && p.content || '?') + '.' },
            error_404: function(p) { return 'Страница ' + (p && p.content || '?') + ' не существует.' },
            cycle: 'Обнаружена циклическая зависимость',
            page: 'Страница',
            grid: 'Страница-грид вставляется на страницу посредством экшена {{grid}}',
        },

        'wiki-formatter': {
            error: function(p) { return 'Ошибка отрисовки ' + (p && p.formatter || '?') + '.' },
        },

        'wiki-action-serviceteam': {
            contacts: 'Контакты сервиса',
            roles: 'Команда сервиса',
            serviceteam: 'Команда сервиса',
        },

        'wiki-action-backlinks': {
            backlinks: 'Страницы, ссылающиеся на данную',
            backlinks_for: function(p) { return 'Страницы, ссылающиеся на ' + (p && p.content || '?') },
        },

        'wiki-action-mywatches': {
            unwatch: 'Отписаться от изменений',
        },

        'wiki-action-mypages': {
            user_pages: 'Страницы пользователя',
            ordered: 'упорядоченные',
        },

        'wiki-action-tasks': {
            'no-tasks': 'Тикеты по данному запросу не найдены.',
        },

        'wiki-action': {
            error: 'Ошибка при получении экшена',
            not_implemented: function(p) { return 'Экшн ' + (p && p.action || '') + ' еще не реализован.' },
            error_args_not_found: function(p) { return 'Не удалось загрузить экшн ' + (p && p.action || '') + '. Не переданы следующие параметры: ' + (p && p.args || '') + '.' },
            error_unauthorized: function(p) { return 'Не удалось загрузить экшн ' + (p && p.action || '') + '. Ошибка авторизации.' },
            error_wiki_api: function(p) { return 'Не удалось загрузить экшн ' + (p && p.action || '') + '. ' + (p && p.error || '') },
            load: 'Загрузить',
            action: 'Экшн',
            error_any: function(p) { return 'Ошибка при получении ' + (p && p.content || '?') },
        },

        'wiki-widget-action': {
            error: 'Ошибка при получении экшена',
        },

        'wiki-action-tree': {
            cluster_tree: 'Структура раздела',
            expand_all: 'Показать все подстраницы',
            full_loaded: 'Все подстраницы загружены',
            not_full_loaded: 'Не все подстраницы загружены',
        },

        'wiki-action-tree-page': {
            created: 'создано',
            modified: 'отредактировано',
        },

        'wiki-action-feed': {
            today: 'сегодня',
        },

        'wiki-head': {
            edit: 'правка',
        },

        'wiki-toc': {
            contents: 'Оглавление документа',
        },

        'wiki-ref': {
            external_link: 'Внешняя ссылка (откроется в новом окне)',
        },

        'wiki-cut': {
            more: 'Подробнее',
        },
    },
};
