const { URL } = require('whatwg-url'); // Чтобы работало и на сервере и на клиенте
const urlJoin = require('url-join');
const merge = require('lodash/merge');

const POST_ACTIONS = new Set([
    'sanitizer',
]);

const FORCE_QUERY_PARAMS = new Set([
    '_$client',
    '_$origin',
]);

function serializeValue(val) {
    if (val === null || val === undefined) {
        return '';
    }

    return String(val);
}

function getDataParams(actionName, actionParams, { schi_url: schiUrl, schiOptions }) {
    const url = new URL(schiUrl);
    const options = merge({}, schiOptions);

    url.pathname = urlJoin(url.pathname, actionName);

    if (POST_ACTIONS.has(actionName)) {
        const body = {};

        for (const [key, val] of Object.entries(actionParams)) {
            if (FORCE_QUERY_PARAMS.has(key)) {
                url.searchParams.append(key, serializeValue(val));
            } else {
                body[key] = serializeValue(val);
            }
        }

        merge(options, {
            method: 'POST',
            body: JSON.stringify(body),
            headers: {
                'Content-Type': 'application/json',
            }
        });
    } else {
        for (const [key, val] of Object.entries(actionParams)) {
            url.searchParams.append(key, serializeValue(val));
        }
    }

    return {
        url: String(url),
        options,
    };
}

function createFetch(fetch) {
    return async(url, options) => {
        const res = await fetch(url, options);
        let json = await res.text();

        try {
            json = JSON.parse(json);
        } catch (err) {}

        if (res.ok) {
            return json;
        }

        throw json && json.error || null;
    };
}

exports.getDataParams = getDataParams;
exports.createFetch = createFetch;
