const escape = require('lodash/escape');

function fallback({ error, version, instance, source }) {
    const href = instance === 'intranet' ?
        'https://nda.ya.ru/3UXz4v' :
        'https://yandex.ru/support/connect-wiki/troubleshooting.html';

    return [
        '<div class="wiki-doc">',
        '<details>',
        '<summary style="outline:0">',
        '🔥 Problem occured while rendering this chunk 🔥',
        '</summary>',
        '<div class="wiki-p">',
        'Please ',
        '<a target="_blank" href="' + href + '">',
        'report this stuff',
        '</a>',
        '</div>',
        '<div class="wiki-p">',
        '<pre>',
        escape(JSON.stringify({ version, domain: error.domain }, null, 2)),
        '</pre>',
        '</div>',
        '<div class="wiki-p">',
        '<pre>',
        escape(error.stack),
        '</pre>',
        '</div>',
        '</details>',
        '</div>',
        '<br/>',
        '<div class="wiki-p">',
        escape(source).replace(/\n/g, '<br/>'),
        '</div>',
    ].join('');
}

module.exports = {
    fallback,
};
