const sources = new Map();

function loadScript(src) {
    const script = document.createElement('script');

    script.type = 'text/javascript';
    script.src = src;

    return new Promise((resolve, reject) => {
        script.onload = resolve;
        script.onerror = reject;

        document.body.appendChild(script);
    });
}

function loadStyles(href) {
    const styles = document.createElement('link');

    styles.rel = 'stylesheet';
    styles.href = href;

    return new Promise((resolve, reject) => {
        styles.onload = resolve;
        styles.onerror = reject;

        document.head.insertBefore(styles, document.head.firstElementChild);
    });
}

function loadSource(src, type) {
    if (sources.get(src) instanceof Promise) {
        return sources.get(src);
    }

    let sourcePromise = Promise.resolve();

    if (type === 'styles') {
        sourcePromise = loadStyles(src);
    } else if (type === 'script') {
        sourcePromise = loadScript(src);
    }

    sources.set(src, sourcePromise);

    return sourcePromise;
}

exports.loadStyles = loadStyles;
exports.loadScript = loadScript;
exports.loadSource = loadSource;
