const { parseWikiMd, formatMdAst } = require('@yandex-int/woofmd-to-bemjson');

async function textToJson(text, settings) {
    try {
        const ast = parseWikiMd(text, settings);
        return await formatMdAst(ast, settings);
    } catch (error) {
        error.domain = 'woofmd';

        throw error;
    }
}

function jsonToHtml(json, BEMHTML) {
    try {
        return BEMHTML.apply(json);
    } catch (error) {
        error.domain = 'wf-bl';

        throw error;
    }
}

exports.textToJson = textToJson;
exports.jsonToHtml = jsonToHtml;
