var BEMHTML;

(function(global) {
    function buildBemXjst(__bem_xjst_libs__) {
        var exports = {};

        /// -------------------------------------
/// --------- BEM-XJST Runtime Start ----
/// -------------------------------------
var BEMHTML = function(module, exports) {
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.bemhtml = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var inherits = require('inherits');
var Match = require('../bemxjst/match').Match;
var BemxjstEntity = require('../bemxjst/entity').Entity;

/**
 * @class Entity
 * @param {BEMXJST} bemxjst
 * @param {String} block
 * @param {String} elem
 * @param {Array} templates
 */
function Entity(bemxjst) {
  this.bemxjst = bemxjst;

  this.jsClass = null;

  // "Fast modes"
  this.tag = new Match(this, 'tag');
  this.attrs = new Match(this, 'attrs');
  this.js = new Match(this, 'js');
  this.mix = new Match(this, 'mix');
  this.bem = new Match(this, 'bem');
  this.cls = new Match(this, 'cls');

  BemxjstEntity.apply(this, arguments);
}

inherits(Entity, BemxjstEntity);
exports.Entity = Entity;

Entity.prototype.init = function(block, elem) {
  this.block = block;
  this.elem = elem;

  // Class for jsParams
  this.jsClass = this.bemxjst.classBuilder.build(this.block, this.elem);
};

Entity.prototype._initRest = function(key) {
  if (key === 'default') {
    this.rest[key] = this.def;
  } else if (key === 'tag' ||
    key === 'attrs' ||
    key === 'js' ||
    key === 'mix' ||
    key === 'bem' ||
    key === 'cls' ||
    key === 'content') {
    this.rest[key] = this[key];
  } else {
    if (!this.rest.hasOwnProperty(key))
      this.rest[key] = new Match(this, key);
  }
};

Entity.prototype.defaultBody = function(context) {
  return this.bemxjst.render(context,
                             this,
                             this.tag.exec(context),
                             context.ctx.js !== false ?
                               this.js.exec(context) :
                               undefined,
                             this.bem.exec(context),
                             this.cls.exec(context),
                             this.mix.exec(context),
                             this.attrs.exec(context),
                             this.content.exec(context));
};

},{"../bemxjst/entity":5,"../bemxjst/match":8,"inherits":11}],2:[function(require,module,exports){
var inherits = require('inherits');
var utils = require('../bemxjst/utils');
var Entity = require('./entity').Entity;
var BEMXJST = require('../bemxjst');

function BEMHTML(options) {
  BEMXJST.apply(this, arguments);

  this._shortTagCloser = typeof options.xhtml !== 'undefined' &&
                            options.xhtml ? '/>' : '>';

  this._elemJsInstances = options.elemJsInstances;
  this._omitOptionalEndTags = options.omitOptionalEndTags;
  this._unquotedAttrs = typeof options.unquotedAttrs === 'undefined' ?
    false :
    options.unquotedAttrs;
}

inherits(BEMHTML, BEMXJST);
module.exports = BEMHTML;

BEMHTML.prototype.Entity = Entity;

BEMHTML.prototype.runMany = function(arr) {
  var out = '';
  var context = this.context;
  var prevPos = context.position;
  var prevNotNewList = context._notNewList;

  if (prevNotNewList) {
    context._listLength += arr.length - 1;
  } else {
    context.position = 0;
    context._listLength = arr.length;
  }
  context._notNewList = true;

  if (this.canFlush) {
    for (var i = 0; i < arr.length; i++)
      out += context._flush(this._run(arr[i]));
  } else {
    for (var i = 0; i < arr.length; i++)
      out += this._run(arr[i]);
  }

  if (!prevNotNewList)
    context.position = prevPos;

  return out;
};

BEMHTML.prototype.render = function(context,
                                   entity,
                                   tag,
                                   js,
                                   bem,
                                   cls,
                                   mix,
                                   attrs,
                                   content) {
  var ctx = context.ctx;

  if (tag === undefined)
    tag = 'div';
  else if (!tag)
    return (content || content === 0) ? this._run(content) : '';

  var out = '<' + tag;

  var ctxJS = ctx.js;
  if (ctxJS !== false) {
    if (js === true)
      js = {};

    if (js && js !== ctx.js) {
      if (ctxJS !== true)
        js = utils.extend(ctxJS, js);
    }  else if (ctxJS === true) {
      js = {};
    }
  }

  var jsParams;
  if (js) {
    jsParams = {};
    jsParams[entity.jsClass] = js;
  }

  var isBEM = typeof bem !== 'undefined' ? bem : entity.block || entity.elem;
  isBEM = !!isBEM;

  var addJSInitClass = jsParams && (
    this._elemJsInstances ?
      (entity.block || entity.elem) :
      (entity.block && !entity.elem)
  );

  if (!isBEM && !cls)
    return this.renderClose(out, context, tag, attrs, isBEM, ctx, content);

  out += ' class=';
  var classValue = '';
  if (isBEM) {
    classValue += entity.jsClass;
    classValue += this.buildModsClasses(entity.block, entity.elem,
                                        entity.elem ?
                                          context.elemMods :
                                          context.mods);

    if (ctx.mix && mix && mix !== ctx.mix)
      mix = [].concat(mix, ctx.mix);

    if (mix) {
      var m = this.renderMix(entity, mix, jsParams, addJSInitClass);
      classValue += m.out;
      jsParams = m.jsParams;
      addJSInitClass = m.addJSInitClass;
    }

    if (cls)
      classValue += ' ' + (typeof cls === 'string' ?
                    utils.attrEscape(cls).trim() : cls);
  } else {
    classValue += typeof cls === 'string' ?
      utils.attrEscape(cls).trim() :
      cls;
  }

  if (addJSInitClass)
    classValue += ' i-bem';

  out += this._unquotedAttrs && utils.isUnquotedAttr(classValue) ?
    classValue :
    ('"' + classValue + '"');

  if (isBEM && jsParams)
    out += ' data-woof=\'' + utils.jsAttrEscape(JSON.stringify(jsParams)) + '\'';

  return this.renderClose(out, context, tag, attrs, isBEM, ctx, content);
};

var OPTIONAL_END_TAGS = {
  // html4 https://html.spec.whatwg.org/multipage/syntax.html#optional-tags
  html: 1, head: 1, body: 1, p: 1, ul: 1, ol: 1, li: 1, dt: 1, dd: 1,
  colgroup: 1, thead: 1, tbody: 1, tfoot: 1, tr: 1, th: 1, td: 1, option: 1,

  // html5 https://www.w3.org/TR/html5/syntax.html#optional-tags
  /* dl — Neither tag is omissible */ rb: 1, rt: 1, rtc: 1, rp: 1, optgroup: 1
};

BEMHTML.prototype.renderClose = function(prefix,
                                         context,
                                         tag,
                                         attrs,
                                         isBEM,
                                         ctx,
                                         content) {
  var out = prefix;

  out += this.renderAttrs(attrs, ctx);

  if (utils.isShortTag(tag)) {
    out += this._shortTagCloser;
    if (this.canFlush)
      out = context._flush(out);
  } else {
    out += '>';
    if (this.canFlush)
      out = context._flush(out);

    // TODO(indutny): skip apply next flags
    if (content || content === 0)
      out += this.renderContent(content, isBEM);

    if (!this._omitOptionalEndTags || !OPTIONAL_END_TAGS.hasOwnProperty(tag))
      out += '</' + tag + '>';
  }

  if (this.canFlush)
    out = context._flush(out);
  return out;
};

BEMHTML.prototype.renderAttrs = function(attrs, ctx) {
  var out = '';

  // NOTE: maybe we need to make an array for quicker serialization
  if (utils.isObj(attrs) || utils.isObj(ctx.attrs)) {
    attrs = utils.extend(attrs, ctx.attrs);

    /* jshint forin : false */
    for (var name in attrs) {
      var attr = attrs[name];
      if (attr === undefined || attr === false || attr === null)
        continue;

      if (attr === true) {
        out += ' ' + name;
      } else {
        var attrVal = utils.isSimple(attr) ? attr : this.context.reapply(attr);
        out += ' ' + name + '=';

        out += this._unquotedAttrs && utils.isUnquotedAttr(attrVal) ?
          attrVal :
          ('"' + utils.attrEscape(attrVal) + '"');
      }
    }
  }

  return out;
};

BEMHTML.prototype.renderMix = function(entity, mix, jsParams, addJSInitClass) {
  var visited = {};
  var context = this.context;
  var js = jsParams;
  var addInit = addJSInitClass;

  visited[entity.jsClass] = true;

  // Transform mix to the single-item array if it's not array
  if (!Array.isArray(mix))
    mix = [ mix ];

  var classBuilder = this.classBuilder;

  var out = '';
  for (var i = 0; i < mix.length; i++) {
    var item = mix[i];
    if (!item)
      continue;
    if (typeof item === 'string')
      item = { block: item, elem: undefined };

    var hasItem = false;

    if (item.elem) {
      hasItem = item.elem !== entity.elem && item.elem !== context.elem ||
        item.block && item.block !== entity.block;
    } else if (item.block) {
      hasItem = !(item.block === entity.block && item.mods) ||
        item.mods && entity.elem;
    }

    var block = item.block || item._block || context.block;
    var elem = item.elem || item._elem || context.elem;
    var key = classBuilder.build(block, elem);

    var classElem = item.elem ||
                    item._elem ||
                    (item.block ? undefined : context.elem);
    if (hasItem)
      out += ' ' + classBuilder.build(block, classElem);

    out += this.buildModsClasses(block, classElem,
      (item.elem || !item.block && (item._elem || context.elem)) ?
        item.elemMods : item.mods);

    if (item.js) {
      if (!js)
        js = {};

      js[classBuilder.build(block, item.elem)] =
          item.js === true ? {} : item.js;
      if (!addInit)
        addInit = block && !item.elem;
    }

    // Process nested mixes
    if (!hasItem || visited[key])
      continue;

    visited[key] = true;
    var nestedEntity = this.entities[key];
    if (!nestedEntity)
      continue;

    var oldBlock = context.block;
    var oldElem = context.elem;
    var nestedMix = nestedEntity.mix.exec(context);
    context.elem = oldElem;
    context.block = oldBlock;

    if (!nestedMix)
      continue;

    for (var j = 0; j < nestedMix.length; j++) {
      var nestedItem = nestedMix[j];
      if (!nestedItem) continue;

      if (!nestedItem.block &&
          !nestedItem.elem ||
          !visited[classBuilder.build(nestedItem.block, nestedItem.elem)]) {
        if (nestedItem.block) continue;

        nestedItem._block = block;
        nestedItem._elem = elem;
        mix = mix.slice(0, i + 1).concat(
          nestedItem,
          mix.slice(i + 1)
        );
      }
    }
  }

  return {
    out: out,
    jsParams: js,
    addJSInitClass: addInit
  };
};

BEMHTML.prototype.buildModsClasses = function(block, elem, mods) {
  if (!mods)
    return '';

  var res = '';

  var modName;

  /*jshint -W089 */
  for (modName in mods) {
    if (!mods.hasOwnProperty(modName) || modName === '')
      continue;

    var modVal = mods[modName];
    if (!modVal && modVal !== 0) continue;
    if (typeof modVal !== 'boolean')
      modVal += '';

    var builder = this.classBuilder;
    res += ' ' + (elem ?
                  builder.buildElemClass(block, elem, modName, modVal) :
                  builder.buildBlockClass(block, modName, modVal));
  }

  return res;
};

},{"../bemxjst":7,"../bemxjst/utils":10,"./entity":1,"inherits":11}],3:[function(require,module,exports){
function ClassBuilder(options) {
  this.modDelim = options.mod || '_';
  this.elemDelim = options.elem || '__';
}
exports.ClassBuilder = ClassBuilder;

ClassBuilder.prototype.build = function(block, elem) {
  if (!elem)
    return block;
  else
    return block + this.elemDelim + elem;
};

ClassBuilder.prototype.buildModPostfix = function(modName, modVal) {
  var res = this.modDelim + modName;
  if (modVal !== true) res += this.modDelim + modVal;
  return res;
};

ClassBuilder.prototype.buildBlockClass = function(name, modName, modVal) {
  var res = name;
  if (modVal) res += this.buildModPostfix(modName, modVal);
  return res;
};

ClassBuilder.prototype.buildElemClass = function(block, name, modName, modVal) {
  return this.buildBlockClass(block) +
    this.elemDelim +
    name +
    this.buildModPostfix(modName, modVal);
};

ClassBuilder.prototype.split = function(key) {
  return key.split(this.elemDelim, 2);
};

},{}],4:[function(require,module,exports){
var utils = require('./utils');

function Context(bemxjst) {
  this._bemxjst = bemxjst;

  this.ctx = null;
  this.block = '';

  // Save current block until the next BEM entity
  this._currBlock = '';

  this.elem = null;
  this.mods = {};
  this.elemMods = {};

  this.position = 0;
  this._listLength = 0;
  this._notNewList = false;

  this.escapeContent = bemxjst.options.escapeContent === true;
}
exports.Context = Context;

Context.prototype._flush = null;

Context.prototype.isSimple = utils.isSimple;

Context.prototype.isShortTag = utils.isShortTag;
Context.prototype.extend = utils.extend;
Context.prototype.identify = utils.identify;

Context.prototype.xmlEscape = utils.xmlEscape;
Context.prototype.attrEscape = utils.attrEscape;
Context.prototype.jsAttrEscape = utils.jsAttrEscape;

Context.prototype.isFirst = function() {
  return this.position === 1;
};

Context.prototype.isLast = function() {
  return this.position === this._listLength;
};

Context.prototype.generateId = function() {
  return utils.identify(this.ctx);
};

Context.prototype.reapply = function(ctx) {
  return this._bemxjst.run(ctx);
};

},{"./utils":10}],5:[function(require,module,exports){
var utils = require('./utils');
var Match = require('./match').Match;
var tree = require('./tree');
var Template = tree.Template;
var PropertyMatch = tree.PropertyMatch;
var CompilerOptions = tree.CompilerOptions;

function Entity(bemxjst, block, elem, templates) {
  this.bemxjst = bemxjst;

  this.block = null;
  this.elem = null;

  // Compiler options via `xjstOptions()`
  this.options = {};

  // `true` if entity has just a default renderer for `def()` mode
  this.canFlush = true;

  // "Fast modes"
  this.def = new Match(this);
  this.content = new Match(this, 'content');

  // "Slow modes"
  this.rest = {};

  // Initialize
  this.init(block, elem);
  this.initModes(templates);
}
exports.Entity = Entity;

Entity.prototype.init = function(block, elem) {
  this.block = block;
  this.elem = elem;
};

function contentMode() {
  return this.ctx.content;
}

Entity.prototype.initModes = function(templates) {
  /* jshint maxdepth : false */
  for (var i = 0; i < templates.length; i++) {
    var template = templates[i];

    for (var j = template.predicates.length - 1; j >= 0; j--) {
      var pred = template.predicates[j];
      if (!(pred instanceof PropertyMatch))
        continue;

      if (pred.key !== '_mode')
        continue;

      template.predicates.splice(j, 1);
      this._initRest(pred.value);

      // All templates should go there anyway
      this.rest[pred.value].push(template);
      break;
    }

    if (j === -1)
      this.def.push(template);

    // Merge compiler options
    for (var j = template.predicates.length - 1; j >= 0; j--) {
      var pred = template.predicates[j];
      if (!(pred instanceof CompilerOptions))
        continue;

      this.options = utils.extend(this.options, pred.options);
    }
  }
};

Entity.prototype.prepend = function(other) {
  // Prepend to the slow modes, fast modes are in this hashmap too anyway
  var keys = Object.keys(this.rest);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!other.rest[key])
      continue;

    this.rest[key].prepend(other.rest[key]);
  }

  // Add new slow modes
  keys = Object.keys(other.rest);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (this.rest[key])
      continue;

    this._initRest(key);
    this.rest[key].prepend(other.rest[key]);
  }
};

// NOTE: This could be potentially compiled into inlined invokations
Entity.prototype.run = function(context) {
  if (this.def.count !== 0)
    return this.def.exec(context);

  return this.defaultBody(context);
};

Entity.prototype.setDefaults = function() {
  // Default .content() template for applyNext()
  if (this.content.count !== 0)
    this.content.push(new Template([], contentMode));

  // .def() default
  if (this.def.count !== 0) {
    this.canFlush = this.options.flush || false;
    var self = this;
    this.def.push(new Template([], function defaultBodyProxy() {
      return self.defaultBody(this);
    }));
  }
};

},{"./match":8,"./tree":9,"./utils":10}],6:[function(require,module,exports){
function BEMXJSTError(msg, func) {
  this.name = 'BEMXJSTError';
  this.message = msg;

  if (Error.captureStackTrace)
    Error.captureStackTrace(this, func || this.constructor);
  else
    this.stack = (new Error()).stack;
}

BEMXJSTError.prototype = Object.create(Error.prototype);
BEMXJSTError.prototype.constructor = BEMXJSTError;

exports.BEMXJSTError = BEMXJSTError;

},{}],7:[function(require,module,exports){
var inherits = require('inherits');

var Tree = require('./tree').Tree;
var PropertyMatch = require('./tree').PropertyMatch;
var AddMatch = require('./tree').AddMatch;
var Context = require('./context').Context;
var ClassBuilder = require('./class-builder').ClassBuilder;
var utils = require('./utils');

function BEMXJST(options) {
  this.options = options || {};

  this.entities = null;
  this.defaultEnt = null;

  // Current tree
  this.tree = null;

  // Current match
  this.match = null;

  // Create new Context constructor for overriding prototype
  this.contextConstructor = function ContextChild(bemxjst) {
    Context.call(this, bemxjst);
  };
  inherits(this.contextConstructor, Context);
  this.context = null;

  this.classBuilder = new ClassBuilder(this.options.naming || {});

  // Execution depth, used to invalidate `applyNext` bitfields
  this.depth = 0;

  // Do not call `_flush` on overridden `def()` mode
  this.canFlush = false;

  // oninit templates
  this.oninit = null;

  // Initialize default entity (no block/elem match)
  this.defaultEnt = new this.Entity(this, '', '', []);
  this.defaultElemEnt = new this.Entity(this, '', '', []);
}
module.exports = BEMXJST;

BEMXJST.prototype.locals = Tree.methods
    .concat('local', 'applyCtx', 'applyNext', 'apply');

BEMXJST.prototype.compile = function(code) {
  var self = this;

  function applyCtx() {
    return self._run(self.context.ctx);
  }

  function applyCtxWrap(ctx, changes) {
    // Fast case
    if (!changes)
      return self.local({ ctx: ctx }, applyCtx);

    return self.local(changes, function() {
      return self.local({ ctx: ctx }, applyCtx);
    });
  }

  function apply(mode, changes) {
    return self.applyMode(mode, changes);
  }

  function localWrap(changes) {
    return function localBody(body) {
      return self.local(changes, body);
    };
  }

  var tree = new Tree({
    refs: {
      applyCtx: applyCtxWrap,
      local: localWrap,
      apply: apply
    }
  });

  // Yeah, let people pass functions to us!
  var templates = this.recompileInput(code);

  var out = tree.build(templates, [
    localWrap,
    applyCtxWrap,
    function applyNextWrap(changes) {
      if (changes)
        return self.local(changes, applyNextWrap);
      return self.applyNext();
    },
    apply
  ]);

  // Concatenate templates with existing ones
  // TODO(indutny): it should be possible to incrementally add templates
  if (this.tree) {
    out = {
      templates: out.templates.concat(this.tree.templates),
      oninit: this.tree.oninit.concat(out.oninit)
    };
  }
  this.tree = out;

  // Group block+elem entities into a hashmap
  var ent = this.groupEntities(out.templates);

  // Transform entities from arrays to Entity instances
  ent = this.transformEntities(ent);

  this.entities = ent;
  this.oninit = out.oninit;
};

BEMXJST.prototype.recompileInput = function(code) {
  var args = BEMXJST.prototype.locals;
  // Reuse function if it already has right arguments
  if (typeof code === 'function' && code.length === args.length)
    return code;

  var out = code.toString();

  // Strip the function
  out = out.replace(/^function[^{]+{|}$/g, '');

  // And recompile it with right arguments
  out = new Function(args.join(', '), out);

  return out;
};

BEMXJST.prototype.groupEntities = function(tree) {
  var res = {};
  for (var i = 0; i < tree.length; i++) {
    // Make sure to change only the copy, the original is cached in `this.tree`
    var template = tree[i].clone();
    var block = null;
    var elem;

    elem = undefined;
    for (var j = 0; j < template.predicates.length; j++) {
      var pred = template.predicates[j];
      if (!(pred instanceof PropertyMatch) &&
        !(pred instanceof AddMatch))
        continue;

      if (pred.key === 'block')
        block = pred.value;
      else if (pred.key === 'elem')
        elem = pred.value;
      else
        continue;

      // Remove predicate, we won't much against it
      template.predicates.splice(j, 1);
      j--;
    }

    if (block === null) {
      var msg = 'block(…) subpredicate is not found.\n' +
      '    See template with subpredicates:\n     * ';

      for (var j = 0; j < template.predicates.length; j++) {
        var pred = template.predicates[j];

        if (j !== 0)
          msg += '\n     * ';

        if (pred.key === '_mode') {
          msg += pred.value + '()';
        } else {
          if (Array.isArray(pred.key)) {
            msg += pred.key[0].replace('mods', 'mod')
              .replace('elemMods', 'elemMod') +
              '(\'' + pred.key[1] + '\', \'' + pred.value + '\')';
          } else if (!pred.value || !pred.key) {
            msg += 'match(…)';
          } else {
            msg += pred.key + '(\'' + pred.value + '\')';
          }
        }
      }

      msg += '\n    And template body: \n    (' +
        (typeof template.body === 'function' ?
          template.body :
          JSON.stringify(template.body)) + ')';

      if (typeof BEMXJSTError === 'undefined') {
        BEMXJSTError = require('./error').BEMXJSTError;
      }

      throw new BEMXJSTError(msg);
    }

    var key = this.classBuilder.build(block, elem);

    if (!res[key])
      res[key] = [];
    res[key].push(template);
  }
  return res;
};

BEMXJST.prototype.transformEntities = function(entities) {
  var wildcardElems = [];

  var keys = Object.keys(entities);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];

    // TODO(indutny): pass this values over
    var parts = this.classBuilder.split(key);
    var block = parts[0];
    var elem = parts[1];

    if (elem === '*')
      wildcardElems.push(block);

    entities[key] = new this.Entity(
      this, block, elem, entities[key]);
  }

  // Merge wildcard block templates
  if (entities.hasOwnProperty('*')) {
    var wildcard = entities['*'];
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      if (key === '*')
        continue;

      entities[key].prepend(wildcard);
    }
    this.defaultEnt.prepend(wildcard);
    this.defaultElemEnt.prepend(wildcard);
  }

  // Merge wildcard elem templates
  for (var i = 0; i < wildcardElems.length; i++) {
    var block = wildcardElems[i];
    var wildcardKey = this.classBuilder.build(block, '*');
    var wildcard = entities[wildcardKey];
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      if (key === wildcardKey)
        continue;

      var entity = entities[key];
      if (entity.block !== block)
        continue;

      if (entity.elem === undefined)
        continue;

      entities[key].prepend(wildcard);
    }
    this.defaultElemEnt.prepend(wildcard);
  }

  // Set default templates after merging with wildcard
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    entities[key].setDefaults();
    this.defaultEnt.setDefaults();
    this.defaultElemEnt.setDefaults();
  }

  return entities;
};

BEMXJST.prototype._run = function(context) {
  if (context === undefined || context === '' || context === null)
    return this.runEmpty();
  else if (Array.isArray(context))
    return this.runMany(context);
  else if (
    typeof context.html === 'string' &&
    !context.tag &&
    typeof context.block === 'undefined' &&
    typeof context.elem === 'undefined' &&
    typeof context.cls === 'undefined' &&
    typeof context.attrs === 'undefined'
  )
    return this.runUnescaped(context);
  else if (utils.isSimple(context))
    return this.runSimple(context);

  return this.runOne(context);
};

BEMXJST.prototype.run = function(json) {
  var match = this.match;
  var context = this.context;

  this.match = null;
  this.context = new this.contextConstructor(this);
  this.canFlush = this.context._flush !== null;
  this.depth = 0;
  var res = this._run(json);

  if (this.canFlush)
    res = this.context._flush(res);

  this.match = match;
  this.context = context;

  return res;
};


BEMXJST.prototype.runEmpty = function() {
  this.context._listLength--;
  return '';
};

BEMXJST.prototype.runUnescaped = function(context) {
  this.context._listLength--;
  return '' + context.html;
};

BEMXJST.prototype.runSimple = function(simple) {
  this.context._listLength--;

  if (!simple && simple !== 0 || simple === true)
    return '';

  return typeof simple === 'string' && this.context.escapeContent ?
    utils.xmlEscape(simple) :
    simple;
};

BEMXJST.prototype.runOne = function(json) {
  var context = this.context;

  var oldCtx = context.ctx;
  var oldBlock = context.block;
  var oldCurrBlock = context._currBlock;
  var oldElem = context.elem;
  var oldMods = context.mods;
  var oldElemMods = context.elemMods;

  if (json.block || json.elem)
    context._currBlock = '';
  else
    context._currBlock = context.block;

  context.ctx = json;
  if (json.block) {
    context.block = json.block;

    if (json.mods)
      context.mods = json.mods;
    else if (json.block !== oldBlock || !json.elem)
      context.mods = {};
  } else {
    if (!json.elem)
      context.block = '';
    else if (oldCurrBlock)
      context.block = oldCurrBlock;
  }

  context.elem = json.elem;
  if (json.elemMods)
    context.elemMods = json.elemMods;
  else
    context.elemMods = {};

  var block = context.block || '';
  var elem = context.elem;

  // Control list position
  if (block || elem)
    context.position++;
  else
    context._listLength--;

  // To invalidate `applyNext` flags
  this.depth++;

  var restoreFlush = false;
  var ent = this.entities[this.classBuilder.build(block, elem)];
  if (ent) {
    if (this.canFlush && !ent.canFlush) {
      // Entity does not support flushing, do not flush anything nested
      restoreFlush = true;
      this.canFlush = false;
    }
  } else {
    // No entity - use default one
    ent = this.defaultEnt;
    if (elem !== undefined)
      ent = this.defaultElemEnt;
    ent.init(block, elem);
  }

  var res = this.options.production === true ?
    this.tryRun(context, ent) :
    ent.run(context);

  context.ctx = oldCtx;
  context.block = oldBlock;
  context.elem = oldElem;
  context.mods = oldMods;
  context.elemMods = oldElemMods;
  context._currBlock = oldCurrBlock;
  this.depth--;
  if (restoreFlush)
    this.canFlush = true;

  return res;
};

BEMXJST.prototype.tryRun = function(context, ent) {
  try {
    return ent.run(context);
  } catch (e) {
    console.error('BEMXJST ERROR: cannot render ' +
      [
        'block ' + context.block,
        'elem ' + context.elem,
        'mods ' + JSON.stringify(context.mods),
        'elemMods ' + JSON.stringify(context.elemMods)
      ].join(', '), e);
    return '';
  }
};

BEMXJST.prototype.renderContent = function(content, isBEM) {
  var context = this.context;
  var oldPos = context.position;
  var oldListLength = context._listLength;
  var oldNotNewList = context._notNewList;

  context._notNewList = false;
  if (isBEM) {
    context.position = 0;
    context._listLength = 1;
  }

  var res = this._run(content);

  context.position = oldPos;
  context._listLength = oldListLength;
  context._notNewList = oldNotNewList;

  return res;
};

BEMXJST.prototype.local = function(changes, body) {
  var keys = Object.keys(changes);
  var restore = [];
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var parts = key.split('.');

    var value = this.context;
    for (var j = 0; j < parts.length - 1; j++)
      value = value[parts[j]];

    restore.push({
      parts: parts,
      value: value[parts[j]]
    });
    value[parts[j]] = changes[key];
  }

  var res = body.call(this.context);

  for (var i = 0; i < restore.length; i++) {
    var parts = restore[i].parts;
    var value = this.context;
    for (var j = 0; j < parts.length - 1; j++)
      value = value[parts[j]];

    value[parts[j]] = restore[i].value;
  }

  return res;
};

BEMXJST.prototype.applyNext = function() {
  return this.match.exec(this.context);
};

BEMXJST.prototype.applyMode = function(mode, changes) {
  var match = this.match.entity.rest[mode];
  if (!match)
    return this.context.ctx[mode];

  if (!changes)
    return match.exec(this.context);

  var self = this;

  // Allocate function this way, to prevent allocation at the top of the
  // `applyMode`
  var fn = function() {
    return match.exec(self.context);
  };
  return this.local(changes, fn);
};

BEMXJST.prototype.exportApply = function(exports) {
  var self = this;
  exports.apply = function(context) {
    return self.run(context);
  };

  // Add templates at run time
  exports.compile = function(templates) {
    return self.compile(templates);
  };

  exports.BEMContext = self.contextConstructor;

  for (var i = 0; i < self.oninit.length; i++) {
    // NOTE: oninit has global context instead of BEMXJST
    var oninit = self.oninit[i];
    oninit(exports, { BEMContext: exports.BEMContext });
  }
};

},{"./class-builder":3,"./context":4,"./error":6,"./tree":9,"./utils":10,"inherits":11}],8:[function(require,module,exports){
var tree = require('./tree');
var PropertyMatch = tree.PropertyMatch;
var AddMatch = tree.AddMatch;
var WrapMatch = tree.WrapMatch;
var ExtendMatch = tree.ExtendMatch;
var CustomMatch = tree.CustomMatch;

function MatchNested(template, pred) {
  this.template = template;
  this.keys = pred.key;
  this.value = pred.value;
}

MatchNested.prototype.exec = function(context) {
  var val = context;

  for (var i = 0; i < this.keys.length - 1; i++) {
    val = val[this.keys[i]];
    if (!val)
      return false;
  }

  val = val[this.keys[i]];

  if (this.value === true)
    return val !== undefined && val !== '' && val !== false && val !== null;

  return String(val) === this.value;
};

function MatchCustom(template, pred) {
  this.template = template;
  this.body = pred.body;
}

MatchCustom.prototype.exec = function(context) {
  return this.body.call(context, context, context.ctx);
};

function MatchWrap(template) {
  this.template = template;
  this.wrap = null;
}

MatchWrap.prototype.exec = function(context) {
  var res = this.wrap !== context.ctx;
  this.wrap = context.ctx;
  return res;
};

function MatchExtend(template) {
  this.template = template;
  this.wrap = null;
}

MatchExtend.prototype.exec = function(context) {
  var res = this.ext !== context.ctx;
  this.ext = context.ctx;
  return res;
};

function AddWrap(template, pred) {
  this.template = template;
  this.key = pred.key;
  this.value = pred.value;
}

AddWrap.prototype.exec = function(context) {
  return context[this.key] === this.value;
};

function MatchTemplate(mode, template) {
  this.mode = mode;
  this.predicates = new Array(template.predicates.length);
  this.body = template.body;

  var postpone = [];

  for (var i = 0, j = 0; i < this.predicates.length; i++, j++) {
    var pred = template.predicates[i];
    if (pred instanceof PropertyMatch) {
      this.predicates[j] = new MatchNested(this, pred);
    } else if (pred instanceof ExtendMatch) {
      j--;
      postpone.push(new MatchExtend(this));
    } else if (pred instanceof AddMatch) {
      this.predicates[i] = new AddWrap(this, pred);
    } else if (pred instanceof CustomMatch) {
      this.predicates[j] = new MatchCustom(this, pred);

      // Push MatchWrap later, they should not be executed first.
      // Otherwise they will set flag too early, and body might not be executed
    } else if (pred instanceof WrapMatch) {
      j--;
      postpone.push(new MatchWrap(this));
    } else {
      // Skip
      j--;
    }
  }

  // Insert late predicates
  for (var i = 0; i < postpone.length; i++, j++)
    this.predicates[j] = postpone[i];

  if (this.predicates.length !== j)
    this.predicates.length = j;
}
exports.MatchTemplate = MatchTemplate;

function Match(entity, modeName) {
  this.entity = entity;
  this.modeName = modeName;
  this.bemxjst = this.entity.bemxjst;
  this.templates = [];

  // applyNext mask
  this.mask = [ 0 ];

  // We are going to create copies of mask for nested `applyNext()`
  this.maskSize = 0;
  this.maskOffset = 0;

  this.count = 0;
  this.depth = -1;

  this.thrownError = null;
}
exports.Match = Match;

Match.prototype.prepend = function(other) {
  this.templates = other.templates.concat(this.templates);
  this.count += other.count;

  while (Math.ceil(this.count / 31) > this.mask.length)
    this.mask.push(0);

  this.maskSize = this.mask.length;
};

Match.prototype.push = function(template) {
  this.templates.push(new MatchTemplate(this, template));
  this.count++;

  if (Math.ceil(this.count / 31) > this.mask.length)
    this.mask.push(0);

  this.maskSize = this.mask.length;
};

Match.prototype.tryCatch = function(fn, ctx) {
  try {
    return fn.call(ctx, ctx, ctx.ctx);
  } catch (e) {
    this.thrownError = e;
  }
};

Match.prototype.exec = function(context) {
  var save = this.checkDepth();

  var template;
  var bitIndex = this.maskOffset;
  var mask = this.mask[bitIndex];
  var bit = 1;
  for (var i = 0; i < this.count; i++) {
    if ((mask & bit) === 0) {
      template = this.templates[i];
      for (var j = 0; j < template.predicates.length; j++) {
        var pred = template.predicates[j];

        /* jshint maxdepth : false */
        if (!pred.exec(context))
          break;
      }

      // All predicates matched!
      if (j === template.predicates.length)
        break;
    }

    if (bit === 0x40000000) {
      bitIndex++;
      mask = this.mask[bitIndex];
      bit = 1;
    } else {
      bit <<= 1;
    }
  }

  if (i === this.count)
    return context.ctx[this.modeName];

  var oldMask = mask;
  var oldMatch = this.bemxjst.match;
  this.mask[bitIndex] |= bit;
  this.bemxjst.match = this;

  this.thrownError = null;

  var out;
  if (typeof template.body === 'function')
    out = this.tryCatch(template.body, context);
  else
    out = template.body;

  this.mask[bitIndex] = oldMask;
  this.bemxjst.match = oldMatch;
  this.restoreDepth(save);

  var e = this.thrownError;
  if (e !== null) {
    this.thrownError = null;
    throw e;
  }

  return out;
};

Match.prototype.checkDepth = function() {
  if (this.depth === -1) {
    this.depth = this.bemxjst.depth;
    return -1;
  }

  if (this.bemxjst.depth === this.depth)
    return this.depth;

  var depth = this.depth;
  this.depth = this.bemxjst.depth;

  this.maskOffset += this.maskSize;

  while (this.mask.length < this.maskOffset + this.maskSize)
    this.mask.push(0);

  return depth;
};

Match.prototype.restoreDepth = function(depth) {
  if (depth !== -1 && depth !== this.depth)
    this.maskOffset -= this.maskSize;
  this.depth = depth;
};

},{"./tree":9}],9:[function(require,module,exports){
var assert = require('minimalistic-assert');
var inherits = require('inherits');

function Template(predicates, body) {
  this.predicates = predicates;

  this.body = body;
}
exports.Template = Template;

Template.prototype.wrap = function() {
  var body = this.body;
  for (var i = 0; i < this.predicates.length; i++) {
    var pred = this.predicates[i];
    body = pred.wrapBody(body);
  }
  this.body = body;
};

Template.prototype.clone = function() {
  return new Template(this.predicates.slice(), this.body);
};

function MatchBase() {
}
exports.MatchBase = MatchBase;

MatchBase.prototype.wrapBody = function(body) {
  return body;
};

function Item(tree, children) {
  this.conditions = [];
  this.children = [];

  for (var i = children.length - 1; i >= 0; i--) {
    var arg = children[i];
    if (arg instanceof MatchBase)
      this.conditions.push(arg);
    else if (arg === tree.boundBody)
      this.children[i] = tree.queue.pop();
    else
      this.children[i] = arg;
  }
}

function WrapMatch(refs) {
  MatchBase.call(this);

  this.refs = refs;
}
inherits(WrapMatch, MatchBase);
exports.WrapMatch = WrapMatch;

WrapMatch.prototype.wrapBody = function(body) {
  var applyCtx = this.refs.applyCtx;

  if (typeof body !== 'function') {
    return function() {
      return applyCtx(body);
    };
  }

  return function() {
    return applyCtx(body.call(this, this, this.ctx));
  };
};

function ReplaceMatch(refs) {
  MatchBase.call(this);

  this.refs = refs;
}
inherits(ReplaceMatch, MatchBase);
exports.ReplaceMatch = ReplaceMatch;

ReplaceMatch.prototype.wrapBody = function(body) {
  var applyCtx = this.refs.applyCtx;

  if (typeof body !== 'function') {
    return function() {
      return applyCtx(body);
    };
  }

  return function() {
    return applyCtx(body.call(this, this, this.ctx));
  };
};

function ExtendMatch(refs) {
  MatchBase.call(this);

  this.refs = refs;
}
inherits(ExtendMatch, MatchBase);
exports.ExtendMatch = ExtendMatch;

ExtendMatch.prototype.wrapBody = function(body) {
  var applyCtx = this.refs.applyCtx;
  var local = this.refs.local;

  if (typeof body !== 'function') {
    return function() {
      var changes = {};

      var keys = Object.keys(body);
      for (var i = 0; i < keys.length; i++)
        changes[keys[i]] = body[keys[i]];

      return local(changes)(function() {
        return applyCtx(this.ctx);
      });
    };
  }

  return function() {
    var changes = {};

    var obj = body.call(this, this, this.ctx);
    var keys = Object.keys(obj);
    for (var i = 0; i < keys.length; i++)
      changes[keys[i]] = obj[keys[i]];

    return local(changes)(function() {
      return applyCtx(this.ctx);
    });
  };
};

function AddMatch(mode, refs) {
  MatchBase.call(this);

  this.mode = mode;
  this.refs = refs;
}
inherits(AddMatch, MatchBase);
exports.AddMatch = AddMatch;

AddMatch.prototype.wrapBody = function(body) {
  return this[this.mode + 'WrapBody'](body);
};

AddMatch.prototype.appendContentWrapBody = function(body) {
  var refs = this.refs;
  var applyCtx = refs.applyCtx;
  var apply = refs.apply;

  if (typeof body !== 'function') {
    return function() {
      return [ apply('content') , body ];
    };
  }

  return function() {
    return [ apply('content'), applyCtx(body.call(this, this, this.ctx)) ];
  };
};

AddMatch.prototype.prependContentWrapBody = function(body) {
  var refs = this.refs;
  var applyCtx = refs.applyCtx;
  var apply = refs.apply;

  if (typeof body !== 'function') {
    return function() {
      return [ body, apply('content') ];
    };
  }

  return function() {
    return [ applyCtx(body.call(this, this, this.ctx)), apply('content') ];
  };
};

function CompilerOptions(options) {
  MatchBase.call(this);
  this.options = options;
}
inherits(CompilerOptions, MatchBase);
exports.CompilerOptions = CompilerOptions;

function PropertyMatch(key, value) {
  MatchBase.call(this);

  this.key = key;
  this.value = value;
}
inherits(PropertyMatch, MatchBase);
exports.PropertyMatch = PropertyMatch;

function CustomMatch(body) {
  MatchBase.call(this);

  this.body = body;
}
inherits(CustomMatch, MatchBase);
exports.CustomMatch = CustomMatch;

function Tree(options) {
  this.options = options;
  this.refs = this.options.refs;

  this.boundBody = this.body.bind(this);

  var methods = this.methods('body');
  for (var i = 0; i < methods.length; i++) {
    var method = methods[i];
    // NOTE: method.name is empty because of .bind()
    this.boundBody[Tree.methods[i]] = method;
  }

  this.queue = [];
  this.templates = [];
  this.initializers = [];
}
exports.Tree = Tree;

Tree.methods = [
  'match', 'wrap', 'block', 'elem', 'mode', 'mod',
  'elemMod', 'def', 'tag', 'attrs', 'cls', 'js',
  'bem', 'mix', 'content', 'replace', 'extend', 'oninit',
  'xjstOptions', 'appendContent', 'prependContent'
];

Tree.prototype.build = function(templates, apply) {
  var methods = this.methods('global').concat(apply);
  methods[0] = this.match.bind(this);

  templates.apply({}, methods);

  return {
    templates: this.templates.slice().reverse(),
    oninit: this.initializers
  };
};

function methodFactory(self, kind, name) {
  var method = self[name];
  var boundBody = self.boundBody;

  if (kind !== 'body') {
    if (name === 'replace' || name === 'extend' || name === 'wrap') {
      return function() {
        return method.apply(self, arguments);
      };
    }

    return function() {
      method.apply(self, arguments);
      return boundBody;
    };
  }

  return function() {
    var res = method.apply(self, arguments);

    // Insert body into last item
    var child = self.queue.pop();
    var last = self.queue[self.queue.length - 1];
    last.conditions = last.conditions.concat(child.conditions);
    last.children = last.children.concat(child.children);

    if (name === 'replace' || name === 'extend' || name === 'wrap')
      return res;
    return boundBody;
  };
}

Tree.prototype.methods = function(kind) {
  var out = new Array(Tree.methods.length);

  for (var i = 0; i < out.length; i++) {
    var name = Tree.methods[i];
    out[i] = methodFactory(this, kind, name);
  }

  return out;
};

// Called after all matches
Tree.prototype.flush = function(conditions, item) {
  var subcond;

  if (item.conditions)
    subcond = conditions.concat(item.conditions);
  else
    subcond = item.conditions;

  for (var i = 0; i < item.children.length; i++) {
    var arg = item.children[i];

    // Go deeper
    if (arg instanceof Item) {
      this.flush(subcond, item.children[i]);

    // Body
    } else {
      var template = new Template(conditions, arg);
      template.wrap();
      this.templates.push(template);
    }
  }
};

Tree.prototype.body = function() {
  var children = new Array(arguments.length);
  for (var i = 0; i < arguments.length; i++)
    children[i] = arguments[i];

  var child = new Item(this, children);
  this.queue[this.queue.length - 1].children.push(child);

  if (this.queue.length === 1)
    this.flush([], this.queue.shift());

  return this.boundBody;
};

Tree.prototype.match = function() {
  var children = new Array(arguments.length);
  for (var i = 0; i < arguments.length; i++) {
    var arg = arguments[i];
    if (typeof arg === 'function')
      arg = new CustomMatch(arg);
    assert(arg instanceof MatchBase, 'Wrong .match() argument');
    children[i] = arg;
  }

  this.queue.push(new Item(this, children));

  return this.boundBody;
};

Tree.prototype.applyMode = function(args, mode) {
  if (args.length) {
    throw new Error('Predicate should not have arguments but ' +
      JSON.stringify(args) + ' passed');
  }

  return this.mode(mode);
};

Tree.prototype.xjstOptions = function(options) {
  this.queue.push(new Item(this, [
    new CompilerOptions(options)
  ]));
  return this.boundBody;
};

Tree.prototype.block = function(name) {
  return this.match(new PropertyMatch('block', name));
};

Tree.prototype.elem = function(name) {
  return this.match(new PropertyMatch('elem', name));
};

Tree.prototype.mode = function(name) {
  return this.match(new PropertyMatch('_mode', name));
};

Tree.prototype.mod = function(name, value) {
  return this.match(new PropertyMatch([ 'mods', name ],
                                  value === undefined ? true : String(value)));
};

Tree.prototype.elemMod = function(name, value) {
  return this.match(new PropertyMatch([ 'elemMods', name ],
                                  value === undefined ?  true : String(value)));
};

Tree.prototype.def = function() {
  return this.applyMode(arguments, 'default');
};

[ 'tag', 'attrs', 'cls', 'js', 'bem', 'mix', 'content' ]
  .forEach(function(method) {
    Tree.prototype[method] = function() {
      return this.applyMode(arguments, method);
    };
  });

[ 'appendContent', 'prependContent' ].forEach(function(method) {
  Tree.prototype[method] = function() {
    return this.content.apply(this, arguments)
      .match(new AddMatch(method, this.refs));
  };
});

Tree.prototype.wrap = function() {
  return this.def.apply(this, arguments).match(new WrapMatch(this.refs));
};

Tree.prototype.replace = function() {
  return this.def.apply(this, arguments).match(new ReplaceMatch(this.refs));
};

Tree.prototype.extend = function() {
  return this.def.apply(this, arguments).match(new ExtendMatch(this.refs));
};

Tree.prototype.oninit = function(fn) {
  this.initializers.push(fn);
};

},{"inherits":11,"minimalistic-assert":12}],10:[function(require,module,exports){
var amp = '&amp;';
var lt = '&lt;';
var gt = '&gt;';
var quot = '&quot;';
var singleQuot = '&#39;';

var matchXmlRegExp = /[&<>]/;

exports.xmlEscape = function(string) {
  var str = '' + string;
  var match = matchXmlRegExp.exec(str);

  if (!match)
    return str;

  var escape;
  var html = '';
  var index = 0;
  var lastIndex = 0;

  for (index = match.index; index < str.length; index++) {
    switch (str.charCodeAt(index)) {
      case 38: // &
        escape = amp;
        break;
      case 60: // <
        escape = lt;
        break;
      case 62: // >
        escape = gt;
        break;
      default:
        continue;
    }

    if (lastIndex !== index)
      html += str.substring(lastIndex, index);

    lastIndex = index + 1;
    html += escape;
  }

  return lastIndex !== index ?
    html + str.substring(lastIndex, index) :
    html;
};

var matchAttrRegExp = /["&]/;

exports.attrEscape = function(string) {
  var str = '' + string;
  var match = matchAttrRegExp.exec(str);

  if (!match)
    return str;

  var escape;
  var html = '';
  var index = 0;
  var lastIndex = 0;

  for (index = match.index; index < str.length; index++) {
    switch (str.charCodeAt(index)) {
      case 34: // "
        escape = quot;
        break;
      case 38: // &
        escape = amp;
        break;
      default:
        continue;
    }

    if (lastIndex !== index)
      html += str.substring(lastIndex, index);

    lastIndex = index + 1;
    html += escape;
  }

  return lastIndex !== index ?
    html + str.substring(lastIndex, index) :
    html;
};

var matchJsAttrRegExp = /['&]/;

exports.jsAttrEscape = function(string) {
  var str = '' + string;
  var match = matchJsAttrRegExp.exec(str);

  if (!match)
    return str;

  var escape;
  var html = '';
  var index = 0;
  var lastIndex = 0;

  for (index = match.index; index < str.length; index++) {
    switch (str.charCodeAt(index)) {
      case 38: // &
        escape = amp;
        break;
      case 39: // '
        escape = singleQuot;
        break;
      default:
        continue;
    }

    if (lastIndex !== index)
      html += str.substring(lastIndex, index);

    lastIndex = index + 1;
    html += escape;
  }

  return lastIndex !== index ?
    html + str.substring(lastIndex, index) :
    html;
};

exports.extend = function(o1, o2) {
  if (!o1 || !o2)
    return o1 || o2;

  var res = {};
  var n;

  for (n in o1)
    if (o1.hasOwnProperty(n))
      res[n] = o1[n];
  for (n in o2)
    if (o2.hasOwnProperty(n))
      res[n] = o2[n];
  return res;
};

var SHORT_TAGS = { // hash for quick check if tag short
  area: 1, base: 1, br: 1, col: 1, command: 1, embed: 1, hr: 1, img: 1,
  input: 1, keygen: 1, link: 1, meta: 1, param: 1, source: 1, wbr: 1
};

exports.isShortTag = function(t) {
  return SHORT_TAGS.hasOwnProperty(t);
};

exports.isSimple = function isSimple(obj) {
  if (!obj || obj === true) return true;
  if (!obj.block &&
      !obj.elem &&
      !obj.tag &&
      !obj.cls &&
      !obj.attrs &&
      obj.hasOwnProperty('html') &&
      isSimple(obj.html))
    return true;
  return typeof obj === 'string' || typeof obj === 'number';
};

exports.isObj = function(val) {
  return val && typeof val === 'object' && !Array.isArray(val) &&
    val !== null;
};

var uniqCount = 0;
var uniqId = +new Date();
var uniqExpando = '__' + uniqId;
var uniqPrefix = 'uniq' + uniqId;

function getUniq() {
  return uniqPrefix + (++uniqCount);
}
exports.getUniq = getUniq;

exports.identify = function(obj, onlyGet) {
  if (!obj)
    return getUniq();
  if (onlyGet || obj[uniqExpando])
    return obj[uniqExpando];

  var u = getUniq();
  obj[uniqExpando] = u;
  return u;
};

exports.fnToString = function(code) {
  // It is fine to compile without templates at first
  if (!code)
    return '';

  if (typeof code === 'function') {
    // Examples:
    //   function () { … }
    //   function name() { … }
    //   function (a, b) { … }
    //   function name(a, b) { … }
    var regularFunction = /^function\s*[^{]+{|}$/g;

    // Examples:
    //   () => { … }
    //   (a, b) => { … }
    //   _ => { … }
    var arrowFunction = /^(_|\(\w|[^=>]+\))\s=>\s{|}$/g;

    code = code.toString();
    code = code.replace(
      code.indexOf('function') === 0 ? regularFunction : arrowFunction,
    '');
  }

  return code;
};

/**
 * regexp for check may attribute be unquoted
 *
 * https://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.2
 * https://www.w3.org/TR/html5/syntax.html#attributes
 */
var UNQUOTED_ATTR_REGEXP = /^[:\w.-]+$/;

exports.isUnquotedAttr = function(str) {
  return str && UNQUOTED_ATTR_REGEXP.exec(str);
};

},{}],11:[function(require,module,exports){
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}

},{}],12:[function(require,module,exports){
module.exports = assert;

function assert(val, msg) {
  if (!val)
    throw new Error(msg || 'Assertion failed');
}

assert.equal = function assertEqual(l, r, msg) {
  if (l != r)
    throw new Error(msg || ('Assertion failed: ' + l + ' != ' + r));
};

},{}]},{},[2])(2)
});;
  return module.exports ||
      exports.BEMHTML;
}({}, {});
/// -------------------------------------
/// --------- BEM-XJST Runtime End ------
/// -------------------------------------

var api = new BEMHTML({"xhtml":true,"escapeContent":true});
/// -------------------------------------
/// ------ BEM-XJST User-code Start -----
/// -------------------------------------
api.compile(function(match, wrap, block, elem, mode, mod, elemMod, def, tag, attrs, cls, js, bem, mix, content, replace, extend, oninit, xjstOptions, appendContent, prependContent, local, applyCtx, applyNext, apply) {
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-link/wiki-link.bemhtml.js */
block('wiki-link')(

    tag()('a'),

    attrs()(function(self, ctx) {
        return Object.assign({}, applyNext(), {
            href: ctx.href,
            alt: ctx.alt,
            title: ctx.title,
            name: ctx.name,
            target: ctx.target,
        });
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-link/wiki-link.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/context-provider/context-provider.bemhtml.js */
block('context-provider').replace()(function() {
    Object.assign(this, this.ctx.data);
    return this.ctx.content;
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/context-provider/context-provider.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/woof-icon/woof-icon.bemhtml.js */
block('woof-icon')(
    tag()('span')
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/woof-icon/woof-icon.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-toc/__title/wiki-toc__title.bemhtml.js */
block('wiki-toc').elem('title')(
    tag()('legend'),

    content()(function() {
        const urlJoin = require('url-join');

        return [
            this.I18N('wiki-toc', 'contents') + ' ',
            this.ctx.page && {
                block: 'wiki-link',
                href: urlJoin(this.settings.wiki_url, this.ctx.page),
                content: this.ctx.page,
            },
        ];
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-toc/__title/wiki-toc__title.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-toc/__toc/wiki-toc__toc.bemhtml.js */
block('wiki-toc').elem('toc')
    .match(function() { return this.ctx.toc })
    .replace()(function() {
        return this.ctx.toc
            .reduce((result, item) => {
                const isHeading = item.type === 'heading';
                const indexes = this.ctx.indexes;

                if (isHeading && indexes.from && item.depth < indexes.from) {
                    return result;
                }
                if (isHeading && indexes.to && item.depth > indexes.to) {
                    return result;
                }

                return result.concat(isHeading ?
                    {
                        block: 'wiki-tocitem',
                        'wiki-attrs': {
                            anchor: item.anchor,
                            level: item.depth,
                            txt: item.value,
                            isMd: item.isMd,
                            page: this.ctx.page,
                        },
                    } : {
                        elem: 'include',
                        attrs: {
                            'data-page': item.page,
                        },
                    });
            }, []);
    });

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-toc/__toc/wiki-toc__toc.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-ticket/__issue/wiki-ticket__issue.bemhtml.js */
block('wiki-ticket').elem('issue').def()(function() {
    let status = this.ctx['wiki-attrs'] && this.ctx['wiki-attrs'].status;

    return applyCtx({
        block: 'wiki-link',
        href: this.ctx.url,
        mix: [{
            block: 'wiki-ticket',
            elem: 'issue',
        }],
        content: status === 'Closed' ? {
            block: 'wiki-strike',
            content: this.ctx.content,
        } : this.ctx.content,
    });
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-ticket/__issue/wiki-ticket__issue.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-club/wiki-club.bemhtml.js */
block('wiki-club').replace()(function() {
    const urlJoin = require('url-join');

    return this.settings.instance === 'business' ? (this.ctx.case + ':' + this.ctx.content) : {
        block: 'wiki-username',
        mods: { style: 'portal' },
        href: urlJoin(this.settings.at_url, this.ctx.content),
        content: this.ctx.content,
    };
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-club/wiki-club.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-head/__anchor/wiki-head__anchor.bemhtml.js */
block('wiki-head').elem('anchor')(
    tag()('a'),
    attrs()(function() {
        return {
            name: this.ctx.name,
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-head/__anchor/wiki-head__anchor.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/node_modules/@yandex-lego/ui.i-bem/common.blocks/i-bem/__i18n/i-bem__i18n.bemhtml.js */
block('i-bem').elem('i18n').def()(function() {
    if (!this.ctx) {
        return '';
    }

    var ctx = this.ctx,
        keyset = ctx.keyset,
        key = ctx.key,
        params = ctx.params || {};

    if (!(keyset || key)) {
        return '';
    }

    /**
     * Consider `content` is a reserved param that contains
     * valid bemjson data
     */
    ctx.content && (params.content = this.reapply(ctx.content));

    return BEM.I18N(keyset, key, params);
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/node_modules/@yandex-lego/ui.i-bem/common.blocks/i-bem/__i18n/i-bem__i18n.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-question/wiki-question.bemhtml.js */
block('wiki-question').tag()('span');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-question/wiki-question.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-staff/wiki-staff.bemhtml.js */
block('wiki-staff')(

    tag()('span'),

    content()(function() {
        let content;
        let getUserNameBlock = function(content) {
            let mods = {
                style: 'portal',
                'staff-card': 'yes',
            };

            // Модификатор для БУ юзеров
            if (this.ctx['wiki-attrs'].hasOwnProperty('is_active') && this.ctx['wiki-attrs'].is_active === false) {
                mods.type = 'fired';
            }

            return {
                block: 'wiki-username',
                mods: mods,
                login: this.ctx['wiki-attrs'].login,
                case: this.ctx['wiki-attrs'].case,
                at: this.ctx['wiki-attrs'].at,
                content: content,
            };
        }.bind(this);

        // TODO: разобраться, нормально ли, что генерируются две ссылки.
        // WTF
        if (!this.ctx.content) {
            content = getUserNameBlock(this.ctx['wiki-attrs'].name || this.ctx['wiki-attrs'].login);
        } else {
            content = [];

            if (this.ctx.content[0] && this.ctx.content[0]['wiki-attrs'].txt) {
                content.push(getUserNameBlock(this.ctx.content[0]['wiki-attrs'].txt));

                this.ctx.content.splice(0, 1);
            }

            if (this.ctx.content.length) {
                content.push(getUserNameBlock(this.ctx.content));
            }
        }

        return content;
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-staff/wiki-staff.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-iframe/wiki-action-iframe.bemhtml.js */
block('wiki-action-iframe')(

    tag()('iframe'),

    attrs()(function() {
        let data = this.ctx.data;
        let attrs = {
            src: data.src || '',
            allowfullscreen: 'allowfullscreen',
        };

        data.width && (attrs.width = data.width);
        data.height && (attrs.height = data.height);
        data.frameborder && (attrs.frameborder = data.frameborder);
        data.scrolling && (attrs.scrolling = data.scrolling);

        return attrs;
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-iframe/wiki-action-iframe.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-toc/wiki-action-toc.bemhtml.js */
block('wiki-action-toc').replace()(function() {
    return {
        block: 'wiki-toc',
        toc: this.toc,
        data: this.ctx.data,
    };
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-toc/wiki-action-toc.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/b-page-code/b-page-code.bemhtml.js */
block('b-page-code').js()(true);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/b-page-code/b-page-code.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-txt/wiki-txt.bemhtml.js */
block('wiki-txt').replace()(function() {
    let string = this.ctx['wiki-attrs'].txt;

    // ACHTUNG. Руками отменяем эскейпинг
    string = this.ctx.noEscape ? { html: string } : string;

    return string;
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-txt/wiki-txt.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-toc/wiki-toc.bemhtml.js */
block('wiki-toc')(

    mode('indexes')(function() {
        const fromToRegexp = /h(\d)$/;
        const fromResult = fromToRegexp.exec(this.ctx.data.from);
        const toResult = fromToRegexp.exec(this.ctx.data.to);

        return {
            from: fromResult && Number(fromResult[1]),
            to: toResult && Number(toResult[1]),
        };
    }),

    js()(true),

    attrs()(function() {
        return {
            'data-wf': JSON.stringify({
                data: this.ctx.data,
                indexes: apply('indexes'),
            }),
        };
    }),

    tag()('fieldset'),

    match(function() {
        return !this.ctx.data.page;
    }).content()(function() {
        return {
            elem: 'content',
            page: this.ctx.data.page,
            toc: this.ctx.toc,
            indexes: apply('indexes'),
        };
    }),

    elem('content').replace()(function() {
        return [
            {
                elem: 'title',
                page: this.ctx.page,
            },
            {
                elem: 'toc',
                page: this.ctx.page,
                toc: this.ctx.toc,
                indexes: this.ctx.indexes,
            },
        ];
    }),

    match(function() {
        return this.ctx.data.page;
    }).content()(function() {
        let linesWidths = [];
        let i;

        for (i = 0; i < 10; i++) {
            linesWidths.push(require('lodash/random')(90, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: [
                {
                    elem: 'preview-title',
                    content: this.I18N('wiki-toc', 'contents') + ' ' + this.ctx.data.page,
                },
                {
                    elem: 'preview-content',
                    content: linesWidths.map(function(lineWidth) {
                        return {
                            elem: 'preview-content-line',
                            attrs: { style: 'width: ' + lineWidth + 'px;' },
                        };
                    }),
                },
            ],
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-toc/wiki-toc.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-tocitem/wiki-tocitem.bemhtml.js */
block('wiki-tocitem')(
    mode('href')(function() {
        const urlJoin = require('url-join');
        const attrs = this.ctx['wiki-attrs'];
        let href = '';

        if (attrs.page) {
            if (this.settings.page_path) {
                href = attrs.page;
            } else {
                href = urlJoin(this.settings.wiki_url, attrs.page);
            }
        }

        let hash = '#';

        if (attrs.isMd) {
            hash += 'm-';
        }

        return href + hash + attrs.anchor;
    }),

    js()(function() {
        return { href: apply('href') };
    }),

    mix()(function() {
        return [{
            mods: {
                level: String(this.ctx['wiki-attrs'].level),
                md: this.ctx['wiki-attrs'].isMd ? 'yes' : '',
            },
        }];
    }),

    content()(function() {
        const attrs = this.ctx['wiki-attrs'];
        return {
            block: 'wiki-link',
            title: attrs.txt,
            href: apply('href'),
            content: [
                attrs.number && attrs.number + '. ', {
                    block: 'wiki-txt',
                    'wiki-attrs': {
                        txt: attrs.txt,
                    },
                },
            ],
        };
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-tocitem/wiki-tocitem.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/wiki-formatter.bemhtml.js */
block('wiki-formatter')(

    def()(function() {
        return applyNext({ 'mods.wiki': this.settings.page_path ? 'yes' : '' });
    }),

    mix()(function() {
        let isBlock;
        let blockProps = ['wrapper', 'align', 'width', 'height', 'wrapper_align', 'wrapper_width', 'wrapper_height'];
        let attrs = this.ctx['wiki-attrs'];
        let mix = {};

        if (attrs) {
            // При наличии этих полей, делаем форматтер блочным
            isBlock = blockProps.some(function(prop) {
                return attrs.hasOwnProperty(prop);
            });

            if (isBlock) {
                mix.type = 'block';
            }

            if (attrs.hasOwnProperty('wrapper')) {
                mix.wrapper = this.attrEscape(attrs.wrapper);
            }

            if (attrs.align !== 'center') {
                mix.float = this.ctx['wiki-attrs'].align;
            }
        }
        return {
            mods: mix,
        };
    }),

    attrs()(function() {
        if (this.ctx['wiki-attrs']) {
            let newAttrs = {
                style: '',
            };
            let attrs = this.ctx['wiki-attrs'];

            if (attrs.txt) {
                this.settings.formatter = attrs.txt;
                this.settings.action = false;
            }

            if (attrs.border) {
                if (attrs.border === '0') {
                    newAttrs.style += 'border: none;';
                } else {
                    newAttrs.style += 'border: ' + attrs.border + ';';
                }
            }

            if (attrs.width) {
                newAttrs.style += 'width: ' + attrs.width + 'px;';
            }

            if (attrs.height) {
                newAttrs.style += 'height: ' + attrs.height + 'px;';
            }

            if (attrs.align && attrs.align !== 'center') {
                newAttrs.style += 'float: ' + attrs.align + ';';
            } else {
                if (attrs.align === 'center') {
                    newAttrs.style += 'float: none;';
                }

                // однострочный код в одну строку
                if (!attrs.multiline && attrs.width) {
                    newAttrs.style += 'word-wrap: break-word; overflow: auto;'; // мультилайн
                }
            }

            if (attrs.align && attrs.wrapper === 'text') {
                newAttrs.style += 'text-align: ' + attrs.align + ';';
            }

            return newAttrs;
        }
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/wiki-formatter.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-formatter/wiki-formatter.bemhtml.js */
block('wiki-formatter')(

    match(function() {
        return this.ctx['wiki-attrs'] &&
            (this.ctx['wiki-attrs'].wrapper === 'box' || this.ctx['wiki-attrs'].wrapper === 'shade') && !this.ctx._wrapped;
    }).wrap()(function() {
        let ctx = this.ctx;
        let mods = ctx.mods || {};

        mods.wrapper = 'box';
        ctx.mods = mods;
        ctx._wrapped = true;

        return ctx;
    }),

    elem('paranja').content()(function(self) {
        return {
            elem: 'arrow',
            content: [
                {
                    block: 'woof-icon',
                    mods: { type: 'awesome-angle-down' },
                    mix: {
                        block: self.block,
                        elem: 'show',
                    },
                },
                {
                    block: 'woof-icon',
                    mods: { type: 'awesome-angle-up' },
                    mix: {
                        block: self.block,
                        elem: 'hide',
                    },
                },
            ],
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-formatter/wiki-formatter.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_comments.bemhtml.js */
block('wiki-formatter').mod('format', 'comments').replace()('');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_comments.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_math.bemhtml.js */
block('wiki-formatter').mod('format', 'math')(
    content()(function() {
        return {
            block: 'wiki-math',
            style: this.ctx['wiki-attrs'] && this.ctx['wiki-attrs'].hasOwnProperty('outline') ? 'outline' : 'inline',
            content: this.ctx.content,
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_math.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-error/wiki-error.bemhtml.js */
block('wiki-error')(

    mode('html')(
        (self, { error: { message } }) => message,

        match((self, { error: { source } }) => source)(
            (self, { error: { source } }) => self.I18N('wiki-action', 'error_any', {
                content: `${source}.`,
            }),
        ),

        match((self, { error: { slug } }) => slug === 'UNAUTHORIZED')(
            (self, { error }) => self.I18N('wiki-action', 'error_unauthorized', {
                action: error.source,
            })
        ),

        match((self, { error: { slug } }) => slug === 'ARGS_NOT_FOUND')(
            (self, { error }) => self.I18N('wiki-action', 'error_args_not_found', {
                action: error.source,
                args: error.details.args.join(', '),
            })
        ),

        match((self, { error: { slug } }) => slug === 'WIKI_API_ERROR')(
            (self, { error }) => {
                const { apiError } = error.details;
                let message = '';

                if (apiError) {
                    message = Array.isArray(apiError.message) ?
                        apiError.message.join(', ') :
                        (apiError.debug_message || apiError.error_code || '');
                }

                return self.I18N('wiki-action', 'error_wiki_api', {
                    action: error.source,
                    error: message,
                });
            }
        ),
    ),

    content()(
        self => [
            {
                block: 'woof-icon',
                mods: { type: 'awesome-exclamation-triangle' },
                mix: {
                    block: self.block,
                    elem: 'icon',
                },
            },
            {
                elem: 'text',
                content: {
                    html: apply('html'),
                },
            },
        ],
    )
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-error/wiki-error.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_plantuml.bemhtml.js */
block('wiki-formatter').mod('format', 'plantuml')(
    js()(function() {
        return { content: this.ctx.content };
    }),

    content()(function() {
        return {
            block: 'wiki-spin',
            mods: {
                progress: 'yes',
            },
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_plantuml.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_graph.bemhtml.js */
block('wiki-formatter').mod('format', 'graph')(
    js()(function() {
        return {
            data: this.ctx.content,
            width: this.ctx['wiki-attrs'].width,
            height: this.ctx['wiki-attrs'].height,
            type: this.ctx.baseFormat,
        };
    }),

    content()(function() {
        return {
            block: 'wiki-spin',
            mods: {
                progress: 'yes',
            },
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_graph.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-username/wiki-username.bemhtml.js */
block('wiki-username')(

    def().match(function() {
        return typeof this.ctx.login === 'string';
    })(function() {
        this.mods.inflecting = 'yes';

        return applyNext();
    }),

    tag()(function() {
        return (this.ctx.href || this.ctx.login) ? 'a' : 'span';
    }),

    attrs()(function() {
        const urlJoin = require('url-join');
        let href = this.ctx.href;

        if (!href && this.ctx.login) {
            href = urlJoin(this.settings.staff_url, this.ctx.login);
        }

        let a = { href };

        this.ctx.counter && (a.onmousedown = this.ctx.counter);
        return a;
    }),

    content()(function() {
        if (Array.isArray(this.ctx.content)) {
            return this.ctx.content;
        }
        return [{
            elem: 'first-letter',
            content: String(this.ctx.content).charAt(0),
        },
        String(this.ctx.content).slice(1),
        ];
    }),

    elem('first-letter').tag()('span')
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-username/wiki-username.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-ticket/wiki-ticket.bemhtml.js */
block('wiki-ticket')(
    tag()('span'),
    def().match(function() { return !this.ctx.content })(function() {
        const urlJoin = require('url-join');
        let ticketType = '';
        let attrs = this.ctx['wiki-attrs'];
        let link = attrs.link_view ?
            attrs.link_view :
            urlJoin(this.settings.tracker_url, attrs.issue);

        //Get ticket type
        if (link) {
            if (link.indexOf('st.yandex-team') !== -1) {
                ticketType = 'startrek';
            } else if (link.indexOf('jira.yandex-team') !== -1) {
                ticketType = 'jira';
            } else if (link.indexOf('lunapark.yandex-team') !== -1) {
                ticketType = 'lunapark';
            }
        }

        return applyCtx({
            block: 'wiki-ticket',
            mods: {
                mode: attrs.ticket_type || ticketType || 'jira',
            },
            'wiki-attrs': attrs,
            content: [{
                elem: 'issue',
                url: link,
                content: attrs.issue,
                'wiki-attrs': {
                    issue: attrs.issue,
                    status: attrs.status,
                },
            }],
        });
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-ticket/wiki-ticket.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-strike/wiki-strike.bemhtml.js */
block('wiki-strike').tag()('del');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-strike/wiki-strike.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-ref/wiki-ref.bemhtml.js */
block('wiki-ref')(
    replace()(function() {
        const urlJoin = require('url-join');
        const IMAGE_EXTENSIONS = [
            'jpg',
            'jpeg',
            'gif',
            'png',
            'svg',
        ];

        const FILE_EXTENSIONS = [
            'doc', 'docx', 'mht', 'odt', 'rtf', 'txt', 'pdf', 'odp', 'ppt', 'pptx', 'csv', 'ods', 'ots',
            'xls', 'xlsx', 'eml', 'vcf', 'exe', 'aac', 'mka', 'mp3', 'ogg', 'wav', 'wma', 'ai', 'bmp',
            'cdr', 'djvu', 'eps', 'ps', 'psd', 'tga', 'tif', 'tiff', '3gp', 'avi', 'flv', 'm2v', 'mkv',
            'mov', 'mp4', 'mpe', 'mpeg', 'mpg', 'qt', 'vob', 'wmv', '7z', 'arj', 'bz2', 'lzh', 'uc2', 'zip',
            'rar', 'ads', 'adb', 'ada', 'a', 'asm', 'def', 'inc', 'ins', 's', 'sa', 'S', 'src', 'c', 'h',
            'cc', 'cpp', 'cxx', 'hh', 'hpp', 'hxx', 'M', 'pdb', 'cs', 'hs', 'cob', 'erl', 'hrl', 'fth',
            'tok', 'f', 'f90', 'for', 'java', 'cl', 'clisp', 'el', 'l', 'lisp', 'LSP', 'lsp', 'ml', 'lua',
            'makefile', 'GNUMakefile', 'Makefilein', 'Makefileam', 'lm', 'm', 'p', 'pas', 'pl', 'pm', 'ps',
            'psw', 'pc', 'prolog', 'py', 'oak', 'sch', 'scheme', 'SCM', 'scm', 'SM', 'sm', 'ss', 't', 'bib',
            'clo', 'cls', 'ltx', 'sty', 'tex', 'texi', 'texinfo', 'txi', 'y', 'ym', 'yxx', 'yy', 'css',
            'js', 'json', 'sql', 'hs', 'sh', 'bash', 'pyx', 'pyd',
        ];

        // Файлы, с расширениями из этого списка обрабатываются через DocViewer
        const WIKI_DOCVIEWER_FILE_EXTENSIONS = [
            'pdf',
            'doc',
            'docx',
            'ppt',
            'pptx',
            'xls',
            'xlsx',
            'odt',
            'ods',
            'rtf',
        ];

        const url = require('url');

        const result = {
            block: 'wiki-link',
            attrs: {},
            href: this.ctx.url,
            title: this.ctx.title,
            mix: [
                { block: 'wiki-ref' },
            ],
        };

        const isWiki = this.settings.page_path; // `page_path` - настройка, которую использует только Вики

        const parsedUrl = url.parse(this.ctx.url);
        const protocol = parsedUrl.protocol;
        const host = parsedUrl.host;
        const hash = parsedUrl.hash;
        let pathname = parsedUrl.pathname;

        const parsedWikiUrl = url.parse(this.settings.wiki_url);

        const isRelative = (!host && pathname) || (!host && hash) || (isWiki && host && host === parsedWikiUrl.host);

        if (!isRelative) {
            result.attrs.title = result.attrs.title || this.I18N('wiki-ref', 'external_link');
            result.target = '_blank';

            result.mix.push({
                block: 'wiki-ref',
                mods: { magiclink: 'yes' },
            });
        }

        const EXT_RE = /\.(\w+)\/*$/;
        const extMatch = pathname && pathname.match(EXT_RE);
        const ext = extMatch && extMatch[1];

        /**
         * Проверяет содержит ли ссылка любой контент кроме своего урла
         *
         * @param {Context} ctx
         * @returns {Boolean}
         */
        const isSelfLink = ctx => {
            if (!ctx.content) return true;
            if (ctx.content.block !== 'wiki-txt') return false;
            if (!ctx.content['wiki-attrs']) return false;
            if (ctx.content['wiki-attrs'].txt !== ctx.url) return false;

            return true;
        };

        /**
         * Проверяет является ли ссылка, картинкой
         * Ссылка считается картинкой при выполнении следующих условий:
         * - ссылка имеет расширение картинки
         * - ссылка не является ref:
         * - ссылка не содержит в себе никакого контента, кроме своего урла
         *
         * @param {String} ext
         * @param {Context} ctx
         * @returns {Boolean}
         */
        const isImage = (ext, ctx) => {
            // Если ссылка не имеет расширения картинки
            if (!IMAGE_EXTENSIONS.includes(ext)) return false;
            // Если ссылка сгенерированна через ref:
            if (ctx.ref) return false;
            // Если внутри что-то кроме ссылки на саму себя
            if (!isSelfLink(ctx)) return false;

            return true;
        };

        let icon;
        if (FILE_EXTENSIONS.includes(ext)) {
            icon = 'awesome-file-alt';
        } else if (protocol === 'mailto:' || protocol === 'xmpp:') {
            icon = 'awesome-envelope';
        }

        icon = icon ? {
            block: 'woof-icon',
            mods: { type: icon },
        } : '';

        if (this.ctx.content) {
            if (this.ctx.content.block !== 'wiki-img') {
                result.content = [icon, this.ctx.content];
            } else {
                result.content = this.ctx.content;
            }
        } else {
            // Если контент пустой, показываем оригинальную ссылку, как ее ввел пользователь,
            // а не распаршеную
            result.content = this.ctx.url;
        }

        if (!isWiki) {
            if (isImage(ext, this.ctx)) {
                return {
                    block: 'wiki-img',
                    url: result.href,
                };
            }
            return result;
        }

        /**
         * Нормализует путь для Вики-страниц согласно спецификации
         * @see https://wiki.yandex-team.ru/wiki/dev/wikimarkupformatter/reqs/20wt2wom/06ssylochnyejelementy/1ssylkipreobrazuemyevrefuzly/1MarkirovannajaSsylka/#wikiobjectmodelwompredstavlenie
         *
         * @param {String} pathname
         * @returns {String}
         */
        const normalizeWikiPath = pathname => {
            if (pathname.startsWith('/') || pathname === '..' || pathname === '') {
                return pathname;
            }

            if (pathname.startsWith('!/') || pathname === '!') {
                return pathname.replace('!', '.');
            }

            return '../' + pathname;
        };

        /**
        * @param  {String} pathname – path целевой вики-страницы
        * @param  {String} wikiPagePath – path текущей вики-страницы
        * @returns {String} Абсолютная ссылка на целевую вики-страницу
        */
        const getAbsoluteWikiPath = (pathname, wikiPagePath) => {
            wikiPagePath = wikiPagePath || '';
            pathname = normalizeWikiPath(pathname);

            if (!wikiPagePath.startsWith('/')) {
                wikiPagePath = '/' + wikiPagePath;
            }

            if (!wikiPagePath.endsWith('/')) {
                wikiPagePath = wikiPagePath + '/';
            }

            return url.resolve(wikiPagePath, pathname);
        };

        const isRelativeWikiUrl = isRelative && isWiki;
        if (isRelativeWikiUrl && protocol !== 'file:' && pathname) {
            pathname = getAbsoluteWikiPath(pathname, this.settings.page_path);
        }

        // file:/users/login/image.pdf -> /users/login/.files/image.pdf
        let splitedPathname;
        let file;
        let page;
        if (protocol === 'file:' && ext) {
            splitedPathname = pathname.split('/');

            file = splitedPathname.pop();
            page = splitedPathname.join('/');

            page = getAbsoluteWikiPath(page, this.settings.page_path);

            result.href = urlJoin(page, '.files', file);

            if (isImage(ext, this.ctx)) {
                return {
                    block: 'wiki-img',
                    url: result.href,
                };
            }

            result.content = [
                icon,
                isSelfLink(this.ctx) ? 'file:' + file : this.ctx.content,
            ];

            if (WIKI_DOCVIEWER_FILE_EXTENSIONS.includes(ext)) {
                let apiUrl = this.settings.wiki_api_url;
                // append protocol for resolve
                apiUrl = apiUrl.replace(/^(?!(?:\w+:)?\/\/)|^\/\//, 'https://');
                apiUrl = urlJoin(url.resolve(apiUrl, page), file);
                apiUrl = apiUrl.replace(/^(?:https?:)?\/\//, 'ya-wiki://');

                let docViewerUrl = urlJoin(
                    this.settings.docviewer_url
                    // append protocol, for non relative links
                        .replace(/^(?!(?:\w+:)?\/\/)|^\/\//, 'https://'),
                    // Страницы в wiki case insensitive, а в docviewer нет
                    `?url=${apiUrl.toLowerCase()}`
                );

                // это для вики-переопределения, потому что наш механизм в i-extensions тут не справился из-за replace()
                result.mix.push({
                    block: 'wf-ref',
                    mods: { type: 'docviewer' },
                    js: true,
                });
                result.attrs['data-bem'] = JSON.stringify({ 'wf-ref': {} });
                result.attrs['data-wf'] = JSON.stringify({
                    docviewer: docViewerUrl,
                    url: result.href,
                });
            }

            return result;
        }

        // TODO: Узнать зачем это нужно, по blame не понятно
        result.href = url.format(Object.assign({}, parsedUrl, { pathname }));

        if (isImage(ext, this.ctx)) {
            return {
                block: 'wiki-img',
                url: result.href,
            };
        }

        return result;
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-ref/wiki-ref.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-img/wiki-img.bemhtml.js */
block('wiki-img')(

    tag()('img'),

    attrs()(function() {
        const urlJoin = require('url-join');
        const url = require('url');

        // TODO: такие же методы есть в `wiki-ref`. Нужно вынести их общее место.

        /**
         * Нормализует путь для Вики-страниц согласно спецификации
         * @see https://wiki.yandex-team.ru/wiki/dev/wikimarkupformatter/reqs/20wt2wom/06ssylochnyejelementy/1ssylkipreobrazuemyevrefuzly/1MarkirovannajaSsylka/#wikiobjectmodelwompredstavlenie
         *
         * @param {String} pathname
         * @returns {String}
         */
        const normalizeWikiPath = pathname => {
            if (pathname.startsWith('/') || pathname === '..' || pathname === '') {
                return pathname;
            }

            if (pathname.startsWith('!/') || pathname === '!') {
                return pathname.replace('!', '.');
            }

            return '../' + pathname;
        };

        /**
        * @param  {String} pathname – path целевой вики-страницы
        * @param  {String} wikiPagePath – path текущей вики-страницы
        * @returns {String} Абсолютная ссылка на целевую вики-страницу
        */
        const getAbsoluteWikiPath = (pathname, wikiPagePath) => {
            wikiPagePath = wikiPagePath || '';
            pathname = normalizeWikiPath(pathname);

            if (!wikiPagePath.startsWith('/')) {
                wikiPagePath = '/' + wikiPagePath;
            }

            if (!wikiPagePath.endsWith('/')) {
                wikiPagePath = wikiPagePath + '/';
            }

            return url.resolve(wikiPagePath, pathname);
        };

        let src = this.ctx.url;
        const parsedUrl = url.parse(src);
        const protocol = parsedUrl.protocol;
        let pathname = parsedUrl.pathname;

        // file:/users/login/image.pdf -> /users/login/.files/image.pdf
        let splitedPathname;
        let file;
        let page;
        if (protocol === 'file:' && typeof pathname === 'string') {
            splitedPathname = pathname.split('/');

            file = splitedPathname.pop();
            page = splitedPathname.join('/');

            page = getAbsoluteWikiPath(page, this.settings.page_path);

            src = urlJoin(page, '.files', file);
        }

        let attrs = {
            src,
            alt: src,
            border: '0',
        };

        if (this.settings.instance !== 'business' && !this.settings.noHideref) {
            attrs.rel = 'noreferrer';
        }

        this.ctx.width && (attrs.width = this.ctx.width);
        this.ctx.height && (attrs.height = this.ctx.height);
        this.ctx.alt && (attrs.alt = this.ctx.alt);
        this.ctx.title && (attrs.title = this.ctx.title);

        return attrs;
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-img/wiki-img.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-block/wiki-block.bemhtml.js */
block('wiki-block').mix()(function() {
    let attrs = this.ctx['wiki-attrs'];
    let mods = {};
    let result = false;

    if (attrs) {
        if (attrs.multiline === false) {
            mods.type = 'inline';
        }

        if (attrs.mod) {
            mods.role = attrs.mod;
        }

        if (mods.type || mods.role) {
            result = [{
                mods: mods,
            }];
        }
    }

    return result;
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-block/wiki-block.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-bold/wiki-bold.bemhtml.js */
block('wiki-bold')
    .tag()('strong');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-bold/wiki-bold.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-bquot/wiki-bquot.bemhtml.js */
block('wiki-bquot')(

    def()(function() {
        return applyNext({ 'mods.wiki': this.settings.page_path ? 'yes' : '' });
    }),

    tag()('blockquote')
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-bquot/wiki-bquot.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-br/wiki-br.bemhtml.js */
block('wiki-br')(
    bem()(false),
    tag()('br'));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-br/wiki-br.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-cell/wiki-cell.bemhtml.js */
block('wiki-cell')(
    tag()('td'),
    attrs()(function() {
        return this.ctx['wiki-attrs'] && {
            colspan: this.ctx['wiki-attrs'].colspan,
        };
    }),
    content()(function() {
        return this.ctx.content;
    })
);

block('wiki-cell').mod('head', true)(
    tag()('th')
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-cell/wiki-cell.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-color/wiki-color.bemhtml.js */
block('wiki-color')(

    tag()('span'),

    content()(function() {
        return [{
            elem: 'example',
            // ACHTUNG. Руками отменяем эскейпинг
            content: { html: '&#160;&#160;&#160;&#160;' },
            'wiki-attrs': this.ctx['wiki-attrs'],
        }, {
            elem: 'hex',
            content: {
                block: 'wiki-txt',
                'wiki-attrs': {
                    txt: '#' + this.ctx['wiki-attrs'].rgb,
                },
            },
        }];
    }),

    elem('example')(
        tag()('span'),
        attrs()(function() {
            let color = this.ctx['wiki-attrs'].rgb;
            let style = 'background-color: #' + color + ';';

            style = (color === 'fff' || color === 'ffffff') ? style + 'border: 1px solid #eee;' : style;

            return {
                style: style,
            };
        })),

    elem('hex').tag()('span')
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-color/wiki-color.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-definition/wiki-definition.bemhtml.js */
block('wiki-definition')(
    tag()('def'),
    attrs()(function() {
        return {
            title: this.ctx['wiki-attrs'].txt,
        };
    }),
    content()(function() {
        return {
            block: 'wiki-txt',
            'wiki-attrs': {
                txt: this.ctx['wiki-attrs'].term,
            },
        };
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-definition/wiki-definition.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-footnote/wiki-footnote.bemhtml.js */
block('wiki-footnote')(

    def()(function() {
        let ctx = this.ctx;
        let type = ctx['wiki-attrs'].type;
        let kind = ctx['wiki-attrs'].kind;
        let label = ctx['wiki-attrs'].label ? ctx['wiki-attrs'].label : '';
        let name = this.xmlEscape(ctx['wiki-attrs'].name);
        let number = ctx['wiki-attrs'].number;
        let content = ctx.content || label;
        let url;
        let anchor;
        let attrname;

        if (type === 'asterisk') {
            url = (kind === 'ref') ? '#oftn' + number : '#ftn' + number;
            anchor = (kind === 'ref') ? 'ftn' : 'oftn';
            attrname = anchor + number;
            if (!content) { content = (new Array(number + 1)).join('*') }
        } else if (type === 'numeric') {
            url = (kind === 'ref') ? '#oftnd' + number : '#ftnd' + number;
            anchor = (kind === 'ref') ? 'ftnd' : 'oftnd';
            attrname = anchor + number;
            if (!content) { content = number }
        } else if (type === 'named') {
            url = (kind === 'ref') ? '#o' + name : '#' + name;
            anchor = (kind === 'ref') ? '' : 'o';
            attrname = anchor + name;
            if (!content) { content = name }
        }

        return applyNext({
            url: url,
            attrname: attrname,
            content: content,
            'mods.wiki': this.settings.page_path ? 'yes' : '',
            type: type,
            kind: kind,
        });
    }),

    attrs()(function() {
        return {
            name: this.attrname,
        };
    }),

    js()(function() {
        return { href: this.url };
    }),

    tag()(function() {
        return (this.type === 'named' && this.kind === 'note') ? 'span' : 'sup';
    }),

    content()(function() {
        return [{
            block: 'wiki-link',
            href: this.url,
            name: this.attrname,
            content: this.content,
        }];
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-footnote/wiki-footnote.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-superscript/wiki-superscript.bemhtml.js */
block('wiki-superscript').tag()('sup');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-superscript/wiki-superscript.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-head/wiki-head.bemhtml.js */
block('wiki-head')(

    tag()(function() {
        return 'h' + this.ctx['wiki-attrs'].level;
    }),

    attrs()(function() {
        return {
            'data-wf': JSON.stringify({
                anchor: this.ctx['wiki-attrs'].anchor,
                section_local: this.ctx['wiki-attrs'].section_local,
                includesPath: this.settings.includes_path || [],
                text: this.ctx['wiki-attrs'].text,
            }),
        };
    }),

    js()(true),

    content()(function() {
        return [
            {
                elem: 'anchors',
            },
            {
                elem: 'text',
                content: applyNext(),
            },
            {
                elem: 'anchor-link',
            },
        ];
    })
);

block('wiki-head').elem('text').tag()('span');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-head/wiki-head.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-hr/wiki-hr.bemhtml.js */
block('wiki-hr')(
    tag()('hr'),
    attrs()({
        size: 1,
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-hr/wiki-hr.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-italic/wiki-italic.bemhtml.js */
block('wiki-italic').tag()('i');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-italic/wiki-italic.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-li/wiki-li.bemhtml.js */
block('wiki-li')(
    tag()('li'),

    attrs()(
        match((self, ctx) => ctx['wiki-attrs'].value)(
            (self, ctx) => Object.assign({}, applyNext(), {
                value: ctx['wiki-attrs'].value,
            })
        )
    ),

    content()((self, ctx) => ({
        elem: 'wrapper',
        'wiki-attrs': ctx['wiki-attrs'],
        content: applyNext(),
    })),

    def()(
        match((self, ctx) => typeof ctx['wiki-attrs'].checked === 'boolean')(
            () => applyNext({ 'mods.checkable': 'yes' })
        )
    ),

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-li/wiki-li.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-list/wiki-list.bemhtml.js */
block('wiki-list')(
    tag()(function() {
        return this.ctx['wiki-attrs'].ordered ? 'ol' : 'ul';
    }),
    mix()(function() {
        let attrs = this.ctx['wiki-attrs'];
        let mods = {};

        if (attrs.ordered) {
            mods['list-type'] = attrs.styleType;
        }

        return [{
            mods: mods,
        }];
    }),
    attrs()(function() {
        return this.ctx['wiki-attrs'] && this.ctx['wiki-attrs'].start && {
            start: this.ctx['wiki-attrs'].start,
        };
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-list/wiki-list.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-list/wiki-list.bemhtml.js */
block('wiki-list')(

    js()(true),

    match(function() {
        return this.ctx.content && (this.ctx.content.length > 3);
    }).wrap()(function() {
        let ctx = this.ctx;
        let mods = ctx.mods || {};

        mods.state = 'close';
        ctx.mods = mods;

        return ctx;
    }),

    elem('paranja').content()(function(self) {
        return {
            elem: 'arrow',
            content: [
                {
                    block: 'woof-icon',
                    mods: { type: 'awesome-angle-down' },
                    mix: {
                        block: self.block,
                        elem: 'show',
                    },
                },
                {
                    block: 'woof-icon',
                    mods: { type: 'awesome-angle-up' },
                    mix: {
                        block: self.block,
                        elem: 'hide',
                    },
                },
            ],
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-list/wiki-list.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/node_modules/@yandex-lego/ui.i-bem/common.blocks/i-bem/__i18n/_dummy/i-bem__i18n_dummy_yes.bemhtml.js */
/* global oninit */

oninit(function() {
    (function(global, bem_) {
        if (bem_.I18N) {
            return;
        }

        /**
         * Points to global context
         * @global
         */
        global.BEM = bem_;

        /**
         * `BEM.I18N` API stub
         */
        var i18n = bem_.I18N = function(keyset, key) {
            return key;
        };

        i18n.keyset = function() { return i18n; };
        i18n.key = function(key) { return key; };
        i18n.lang = function() { return; };
    })(this, typeof BEM === 'undefined' ? {} : BEM);
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/node_modules/@yandex-lego/ui.i-bem/common.blocks/i-bem/__i18n/_dummy/i-bem__i18n_dummy_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-list/_state/wiki-list_state_close.bemhtml.js */
block('wiki-list').mod('state', 'close')(

    js()(true),

    content()(function() {
        return [
            applyNext(),
            { elem: 'paranja' },
        ];
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-list/_state/wiki-list_state_close.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-lquot/wiki-lquot.bemhtml.js */
block('wiki-lquot')(
    mix()(function() {
        let level = this.ctx['wiki-attrs'].level;
        let parity = !(level % 2) ? 'even' : 'odd';

        return [{
            mods: {
                parity: parity,
            },
        }];
    }),
    content()(function() {
        let quot = '>';
        let level = this.ctx['wiki-attrs'].level;
        let prefix = '';

        for (let i = 0; i < level; i++) {
            prefix += quot;
        }

        return [prefix].concat(this.ctx.content);
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-lquot/wiki-lquot.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-monospace/wiki-monospace.bemhtml.js */
block('wiki-monospace').tag()('tt');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-monospace/wiki-monospace.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-remark/wiki-remark.bemhtml.js */
block('wiki-remark')(

    tag()('span'),

    mix()(function() {
        let color = this.ctx['wiki-attrs'] && this.ctx['wiki-attrs'].color;

        return color && [{
            mods: {
                color: color,
            },
        }];
    }));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-remark/wiki-remark.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-row/wiki-row.bemhtml.js */
block('wiki-row')(
    tag()('tr'));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-row/wiki-row.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-small/wiki-small.bemhtml.js */
block('wiki-small').tag()('small');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-small/wiki-small.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-subscript/wiki-subscript.bemhtml.js */
block('wiki-subscript').tag()('sub');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-subscript/wiki-subscript.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-table/wiki-table.bemhtml.js */
block('wiki-table')(
    tag()('table'),
    mix()(function() {
        let modsObj = {};

        if (
            this.ctx['wiki-attrs'] &&
            this.ctx['wiki-attrs'].type === 'wide'
        ) {
            modsObj.wide = 'yes';
        } else {
            modsObj.border = 'yes';
        }

        return [{
            mods: modsObj,
        }];
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-table/wiki-table.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-table/wiki-table.bemhtml.js */
block('wiki-table')(

    match(function() {
        return this.ctx['wiki-attrs'] && this.ctx['wiki-attrs'].type !== 'wide';
    }).wrap()(function() {
        return {
            block: 'wiki-table-wrapper',
            mix: { block: 'w-scroller', mods: { type: 'shadows' }, js: true },
            content: {
                elem: 'content',
                mix: { block: 'w-scroller', elem: 'scrollable' },
                content: this.ctx,
            },
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-table/wiki-table.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-underline/wiki-underline.bemhtml.js */
block('wiki-underline').tag()('ins');

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-underline/wiki-underline.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action/wiki-action.bemhtml.js */
block('wiki-action')(

    mode('bemjson')(function() {
        let equals = {
            a: 'anchor',
            statface: 'chart',
        };
        let actionName = this.ctx.name.toLowerCase();
        let originalName = actionName;

        if (equals[actionName]) {
            actionName = equals[actionName];
        }

        return {
            block: 'wiki-action-' + actionName,
            js: { data: this.ctx.params },
            data: this.ctx.params,
            originalName: originalName,
        };
    }),

    mode('is-implemented')(function() {
        let whitelist = [
            'forms',
            'iframe',
            'include',
            'serviceteam',
            'tree',
            'toc',
            'feed',
            'anchor',
            'a',
            'chart',
            'statface',
            'tasks',
            'mypages',
            'mywatches',
            'backlinks',
        ];

        return whitelist.includes(this.ctx.name.toLowerCase());
    }),

    match(function() {
        return apply('is-implemented') && !this.settings.renderActionsByClick;
    }).replace()(function() {
        return apply('bemjson');
    }),

    elem('spin').content()({
        block: 'wiki-spin',
        mods: {
            progress: 'yes',
        },
    }),

    def()(function() {
        return applyNext({
            'mods.wiki': this.settings.page_path ? 'yes' : '',
            'mods.autoload': apply('is-implemented') && this.settings.renderActionsByClick ? 'false' : '',
        });
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action/wiki-action.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-forms/wiki-action-forms.bemhtml.js */
block('wiki-action-forms')(

    def()(function() {
        this.ctx.name = 'forms-' + this.ctx.data.id + '-' + Math.round(Math.random() * 100000);
        return applyNext();
    }),

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    js()(function() {
        let js = this.ctx.js;
        js.data.name = this.ctx.name;
        return js;
    }),

    content()(function() {
        return [{
            block: 'wiki-spin',
            mods: {
                progress: 'yes',
                type: 'load',
            },
        }, {
            elem: 'form',
            name: this.ctx.name,
        }];
    }),

    elem('form')(
        tag()('iframe'),

        attrs()(function() {
            return {
                frameborder: 0,
                name: this.ctx.name,
            };
        })
    )

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-forms/wiki-action-forms.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/wiki-action-tree-page.bemhtml.js */
block('wiki-action-tree-page')(

    js()(function() {
        return {
            data: this.ctx.data,
        };
    }),

    content()(function() {
        return [
            {
                elem: 'expand',
            },
            {
                elem: 'content',
                data: this.ctx.data,
                wikiUrl: this.ctx.wikiUrl,
                staffUrl: this.ctx.staffUrl,
                isWiki: this.ctx.isWiki,
            },
        ];
    }),

    elem('content').content()(function() {
        const urlJoin = require('url-join');
        let data = this.ctx.data;
        let type = data.page.type.toLowerCase();
        let url = data.page.url;

        // В случае несуществующей страницы слать на виджет создания страницы
        if (type === 'n') {
            url = urlJoin(url, '.create');
        }

        return [
            {
                elem: 'self',
                content: [
                    {
                        block: 'wiki-link',
                        mods: {
                            type: type,
                        },
                        // http://st/WIKI-13487
                        href: urlJoin(this.ctx.isWiki ? '/' : this.ctx.wikiUrl, url),
                        content: data.page.title || data.page.cluster,
                    },
                    {
                        elem: 'type-icon',
                    },
                    data.page.authors && {
                        elem: 'authors',
                        authors: data.page.authors,
                        staffUrl: this.ctx.staffUrl,
                    },
                    {
                        elem: 'created',
                        time: data.page.created_at,
                    },
                    {
                        elem: 'modified',
                        time: data.page.modified_at,
                    },
                    data.page.files && {
                        elem: 'files',
                        files: data.page.files,
                        wikiUrl: this.ctx.wikiUrl,
                    },
                ],
            },
            {
                elem: 'children',
                subpages: data.subpages,
                wikiUrl: this.ctx.wikiUrl,
                staffUrl: this.ctx.staffUrl,
                isWiki: this.ctx.isWiki,
            },
        ];
    }),

    elem('authors').replace()(function() {
        const urlJoin = require('url-join');
        let authors = this.ctx.authors;
        let self = this;

        return authors && authors.map(function(author, index) {
            return [
                {
                    block: 'wiki-username',
                    mods: { style: 'portal', 'staff-card': 'yes' },
                    login: author.login,
                    href: urlJoin(self.ctx.staffUrl, author.login),
                    content: author.login,
                },
                index !== (authors.length - 1) ? ',' : '',
            ];
        });
    }),

    elem('created')
        .match(function() { return this.ctx.time })
        .content()(function() {
            return this.I18N('wiki-action-tree-page', 'created') + ': ' + new Date(this.ctx.time * 1000).toLocaleDateString(); // eslint-disable-line max-len
        }),

    elem('created')
        .match(function() { return !this.ctx.time })
        .replace()(''),

    elem('modified')
        .match(function() { return this.ctx.time })
        .content()(function() {
            return this.I18N('wiki-action-tree-page', 'modified') + ': ' + new Date(this.ctx.time * 1000).toLocaleDateString(); // eslint-disable-line max-len
        }),

    elem('modified')
        .match(function() { return !this.ctx.time })
        .replace()(''),

    elem('files').content()(function() {
        let files = this.ctx.files;
        let visibleCount = 2;
        return [
            { elem: 'left-bracket' },
            files.slice(0, visibleCount).map(function(file, index) {
                let last = (index === files.length - 1);
                return [
                    {
                        elem: 'file',
                        data: file,
                    },
                    !last && ',',
                ];
            }),
            (files.length > 2) && ' ...',
            { elem: 'right-bracket' },
        ];
    }),

    elem('file').content()(function() {
        return [
            {
                block: 'woof-icon',
                mods: { type: 'awesome-file-alt' },
            },
            {
                block: 'wiki-link',
                mods: {
                    type: 'file',
                },
                href: this.ctx.data.url,
                content: this.ctx.data.name,
            },
        ];
    }),

    elem('left-bracket').content()('('),
    elem('right-bracket').content()(')'),

    elem('children').content()(function() {
        let self = this;
        return this.ctx.subpages && this.ctx.subpages.map(function(pageData) {
            return {
                block: 'wiki-action-tree-page',
                mods: {
                    expandable: pageData.expand_url || pageData.subpages.length ? 'yes' : '',
                    expanded: pageData.subpages.length ? 'yes' : '',
                    'data-loaded': pageData.subpages.length ? 'yes' : '',
                    type: pageData.page.type.toLowerCase(),
                },
                data: pageData,
                wikiUrl: self.ctx.wikiUrl,
                staffUrl: self.ctx.staffUrl,
                isWiki: self.ctx.isWiki,
            };
        });
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/wiki-action-tree-page.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_c.bemhtml.js */
block('wiki-action-tree-page').mod('type', 'c').elem('type-icon').replace()(self => ({
    block: 'woof-icon',
    mods: { type: 'awesome-lock' },
    mix: {
        block: self.block,
        elem: self.elem,
    },
}));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_c.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_r.bemhtml.js */
block('wiki-action-tree-page').mod('type', 'r').elem('type-icon').replace()(self => ({
    block: 'woof-icon',
    mods: { type: 'awesome-share' },
    mix: {
        block: self.block,
        elem: self.elem,
    },
}));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_r.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_g.bemhtml.js */
block('wiki-action-tree-page').mod('type', 'g').elem('type-icon').replace()(self => ({
    block: 'woof-icon',
    mods: { type: 'awesome-table' },
    mix: {
        block: self.block,
        elem: self.elem,
    },
}));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_g.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-serviceteam/wiki-action-serviceteam.bemhtml.js */
block('wiki-action-serviceteam')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let lines = [];
        let i; let j;

        for (i = 0; i < 4; i++) {
            let roleWidth = require('lodash/random')(80, 160);
            let roleLength = require('lodash/random')(1, 3);
            let roles = [];

            for (j = 0; j < roleLength; j++) {
                roles.push(require('lodash/random')(80, 150));
            }

            lines.push([roleWidth, roles]);
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: [
                {
                    elem: 'preview-title',
                    content: [
                        this.I18N('wiki-action-serviceteam', 'serviceteam'),
                        {
                            block: 'wiki-action',
                            elem: 'preview-title-placeholder',
                        },
                    ],
                },
                {
                    elem: 'preview-content',
                    content: lines.map(function(line) {
                        return {
                            elem: 'preview-content-line',
                            content: [
                                {
                                    elem: 'preview-content-line-role',
                                    attrs: { style: 'width: ' + line[0] + 'px;' },
                                },
                                {
                                    elem: 'preview-content-line-users',
                                    content: line[1].map(function(roleWidth) {
                                        return {
                                            elem: 'preview-content-line-user',
                                            attrs: { style: 'width: ' + roleWidth + 'px;' },
                                        };
                                    }),
                                },
                            ],
                        };
                    }),
                },
            ],
        };
    }),

    elem('content').content()(function() {
        let data = this.ctx.data.data;
        let type = data.roles ? 'roles' : 'contacts';

        return [{
            elem: 'header',
            label: data.service_name,
            editUrl: data.edit_url,
            type: type,
        }, {
            elem: 'info',
            data: data,
            staffUrl: this.ctx.staffUrl,
        }];
    }),

    elem('header').content()(function() {
        return [{
            elem: 'label',
            content: this.I18N('wiki-action-serviceteam', this.ctx.type) + ' «' + this.ctx.label + '»',
        }, {
            block: 'wiki-link',
            href: this.ctx.editUrl,
            mix: {
                block: this.block,
                elem: 'edit',
            },
            content: {
                block: 'woof-icon',
                mods: { type: 'awesome-pencil-alt' },
            },
        }];
    }),

    elem('info')
        .match(function() { return this.ctx.data.roles })
        .content()(function() {
            let staffUrl = this.ctx.staffUrl;
            return this.ctx.data.roles.map(function(role) {
                return {
                    elem: 'role',
                    data: role,
                    staffUrl: staffUrl,
                };
            });
        }),

    elem('info')
        .match(function() { return this.ctx.data.contacts })
        .content()(function() {
            let staffUrl = this.ctx.staffUrl;
            return this.ctx.data.contacts.map(function(contact) {
                return {
                    elem: 'contact',
                    data: contact,
                    staffUrl: staffUrl,
                };
            });
        }),

    elem('role').content()(function() {
        const urlJoin = require('url-join');
        let persons = this.ctx.data.persons;
        let lang = this.I18N.lang();

        return [{
            elem: 'role-header',
            content: this.ctx.data.name,
        }, {
            elem: 'persons',
            content: persons.map(function(person, index) {
                let last = index === persons.length - 1;
                return [{
                    elem: 'person',
                    content: [{
                        block: 'wiki-username',
                        mods: { 'staff-card': 'yes' },
                        login: person.login,
                        href: urlJoin(this.ctx.staffUrl, person.login),
                        content: typeof person.first_name === 'string' ?
                            (person.first_name + ' ' + person.last_name) :
                            person.name[lang],
                    }, !last && ','],
                }, !last && ' '];
            }, this),
        }];
    }),

    elem('contact').content()(function() {
        let lang = this.I18N.lang();
        return {
            block: 'wiki-link',
            mix: {
                block: this.block,
                elem: 'link',
            },
            href: this.ctx.data.link,
            content: [
                {
                    block: 'woof-icon',
                    mods: {
                        type: this.ctx.data.type.replace(/_/g, '-'),
                    },
                    mix: {
                        block: this.block,
                        elem: 'icon',
                    },
                },
                {
                    elem: 'inner',
                    content: this.ctx.data.text[lang],
                },
            ],
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-serviceteam/wiki-action-serviceteam.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-helpers/wiki-helpers.bemhtml.js */
oninit(function(exports) {
    exports.BEMContext.prototype['wiki-helpers'] = {
        isTrueParam: function(param) {
            return param === '1' || param === 'true' || param === null;
        },
    };
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-helpers/wiki-helpers.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-anchor/wiki-action-anchor.bemhtml.js */
block('wiki-action-anchor')(
    tag()('span'),

    content()(function() {
        let data = this.ctx.data;
        let name = data.href || data.name;

        return [
            {
                elem: 'anchor',
                tag: 'a',
                attrs: {
                    name: name,
                },
            },
            {
                block: 'wiki-link',
                mix: {
                    block: this.block,
                    elem: 'link',
                },
                href: '#' + name,
                content: data.text,
                title: data.title,
            },
        ];
    }),

    js()(function() {
        return {
            name: this.ctx.data.href || this.ctx.data.name,
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-anchor/wiki-action-anchor.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-chart/wiki-action-chart.bemhtml.js */
block('wiki-action-chart')(

    js()(function() {
        return Object.assign({}, this.ctx.js, {
            lang: this.settings.lang,
            schi_url: this.settings.schi_url,
            statface_url: this.settings.statface_url,
            charts_url: this.settings.charts_url,
        });
    }),

    content()(function() {
        let data = this.ctx.js.data;
        let style = '';
        let defaultSizes = {
            chart: {
                width: '400px',
                height: '400px',
            },
            statface: {
                width: '',
                height: '350px',
            },
        };

        /**
         * @param {'width'|'height'} type
         * @returns {String}
         */
        let getSize = function(type) {
            // '200'/'200px'
            return data[type] === String(parseInt(data[type])) ?
                data[type] + 'px' : data[type];
        };

        let width = getSize('width') || defaultSizes[this.ctx.originalName].width;
        let height = getSize('height') || defaultSizes[this.ctx.originalName].height;
        let hasFrame = this.ctx.originalName === 'statface' && !this['wiki-helpers'].isTrueParam(data.nomark);

        if (width) {
            style += 'width: ' + width + ';';
        }

        if (height) {
            style += 'height: ' + height + ';';
        }

        let chart = {
            elem: 'chart',
            cls: 'yandex-charts-visual-element',
            attrs: {
                'data-src': data.src,
                style: style,
            },
        };

        return hasFrame ? {
            elem: 'frame',
            tag: 'fieldset',
            content: [
                data.title ? { elem: 'legend', tag: 'legend', content: data.title } : '',
                chart,
            ],
        } : chart;
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-chart/wiki-action-chart.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tasks/wiki-action-tasks.bemhtml.js */
block('wiki-action-tasks')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let random = require('lodash/random');
        let lines = [];
        let i;

        for (i = 0; i < 6; i++) {
            lines.push(random(120, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: {
                elem: 'preview-content',
                content: lines.map(function(line) {
                    return {
                        elem: 'preview-content-line',
                        content: {
                            elem: 'preview-content-line-task',
                            attrs: { style: 'width: ' + line + 'px;' },
                        },
                    };
                }),
            },
        };
    }),

    elem('content').content()(function() {
        return this.ctx.tickets.map(function(ticket) {
            return {
                elem: 'ticket',
                content: {
                    block: 'wiki-ticket',
                    'wiki-attrs': {
                        issue: ticket,
                    },
                },
            };
        });
    }),

    elem('no-tasks').content()(function() {
        return this.I18N('wiki-action-tasks', 'no-tasks');
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tasks/wiki-action-tasks.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-mypages/wiki-action-mypages.bemhtml.js */
block('wiki-action-mypages')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let random = require('lodash/random');
        let lines = [];
        let i;

        for (i = 0; i < 8; i++) {
            lines.push(random(120, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: {
                elem: 'preview-content',
                content: lines.map(function(line) {
                    return {
                        elem: 'preview-content-line',
                        content: {
                            elem: 'preview-content-line-page',
                            attrs: { style: 'width: ' + line + 'px;' },
                        },
                    };
                }),
            },
        };
    }),

    elem('content').content()(function() {
        const urlJoin = require('url-join');
        const data = this.ctx.data;
        const self = this;

        return [
            {
                elem: 'title',
                content: [
                    {
                        elem: 'title-user',
                        content: [
                            this.I18N('wiki-action-mypages', 'user_pages') + ' ',
                            {
                                block: 'wiki-username',
                                mods: { 'staff-card': 'yes' },
                                login: data.login,
                                content: data.login,
                            },
                        ],
                    },
                    {
                        elem: 'title-order',
                        content: ', ' + this.I18N('wiki-action-mypages', 'ordered') + ' ' + data.order_by + ':',
                    },
                ],
            },
            data.split_entities.map(function(entity) {
                return {
                    elem: 'group',
                    content: [
                        {
                            elem: 'group-title',
                            content: (data.sort_by_letter ?
                                entity.key.toUpperCase() : entity.key.replace(/ .*$/g, '')) + ':',
                        },
                        {
                            elem: 'group-pages',
                            content: entity.pages.map(function(page) {
                                let time = null;

                                if (data.sort_by_change) {
                                    time = new Date(page.modified_at);
                                }
                                if (data.sort_by_date) {
                                    time = new Date(page.created_at);
                                }

                                if (time) {
                                    // не хочу тянуть moment
                                    time = new Date(Date.UTC(
                                        time.getFullYear(),
                                        time.getMonth(),
                                        time.getDate(),
                                        time.getHours(),
                                        time.getMinutes()
                                    ));
                                    time = `${
                                        String(time.getHours()).padStart(2, '0')
                                    }:${
                                        String(time.getMinutes()).padStart(2, '0')
                                    }`;
                                }

                                return {
                                    elem: 'group-page',
                                    content: [
                                        time ? (time + ' – ') : '',
                                        {
                                            block: 'wiki-link',
                                            href: urlJoin(self.settings.wiki_url, page.url),
                                            content: page.tag.replace(/\//g, ' / '),
                                        },
                                    ],
                                };
                            }),
                        },
                    ],
                };
            }),
        ];
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-mypages/wiki-action-mypages.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-mywatches/wiki-action-mywatches.bemhtml.js */
block('wiki-action-mywatches')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let random = require('lodash/random');
        let lines = [];
        let i;

        for (i = 0; i < 8; i++) {
            lines.push(random(120, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: {
                elem: 'preview-content',
                content: lines.map(function(line) {
                    return {
                        elem: 'preview-content-line',
                        content: {
                            elem: 'preview-content-line-page',
                            attrs: { style: 'width: ' + line + 'px;' },
                        },
                    };
                }),
            },
        };
    }),

    elem('content').content()(function() {
        const data = this.ctx.data;
        const self = this;
        const urlJoin = require('url-join');

        return data.map(function(page) {
            return {
                elem: 'page',
                content: [
                    {
                        block: 'wiki-link',
                        mods: { role: 'main' },
                        href: urlJoin(self.settings.wiki_url, page.url),
                        content: page.tag,
                    },
                    {
                        block: 'wiki-link',
                        mods: { role: 'unwatch' },
                        href: urlJoin(self.settings.wiki_url, page.url, '/.unwatch'),
                        content: self.I18N('wiki-action-mywatches', 'unwatch'),
                    },
                ],
            };
        });
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-mywatches/wiki-action-mywatches.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-backlinks/wiki-action-backlinks.bemhtml.js */
block('wiki-action-backlinks')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let random = require('lodash/random');
        let lines = [];
        let i;

        for (i = 0; i < 8; i++) {
            lines.push(random(120, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: {
                elem: 'preview-content',
                content: lines.map(function(line) {
                    return {
                        elem: 'preview-content-line',
                        content: {
                            elem: 'preview-content-line-page',
                            attrs: { style: 'width: ' + line + 'px;' },
                        },
                    };
                }),
            },
        };
    }),

    elem('content').content()(function() {
        const data = this.ctx.data;
        const page = this.ctx.page;
        const self = this;
        const url = require('url');

        return {
            elem: 'frame',
            tag: 'fieldset',
            content: [{
                elem: 'legend',
                tag: 'legend',
                content: page ? this.I18N('wiki-action-backlinks', 'backlinks_for', { content: page }) :
                    this.I18N('wiki-action-backlinks', 'backlinks'),
            }].concat(data.map(function(page) {
                return {
                    elem: 'page',
                    content: {
                        block: 'wiki-link',
                        mods: { role: 'main' },
                        href: url.resolve(self.settings.wiki_url, page.link),
                        name: page.name,
                        content: page.label,
                    },
                };
            })),
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-backlinks/wiki-action-backlinks.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-sanitizer/wiki-sanitizer.bemhtml.js */
block('wiki-sanitizer')(
    replace()(
        match((self, { html }) => typeof html === 'string')(
            ((self, { html }) => ({ html }))
        ),

        match((self, { error }) => error)(
            ((self, { error }) => ({
                block: 'wiki-error',
                error,
                mix: {
                    block: self.block,
                    mods: self.mods,
                    mix: apply('mix'),
                },
            }))
        )
    )
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-sanitizer/wiki-sanitizer.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/b-page-code/_inline/b-page-code_inline_yes.bemhtml.js */
block('b-page-code')(
    content()(function() {
        return {
            elem: 'code',
            tag: 'code',
            mix: {
                block: this.ctx.lang,
            },
            content: this.ctx.code,
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/b-page-code/_inline/b-page-code_inline_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/b-page-code/_multiline/b-page-code_multiline_yes.bemhtml.js */
block('b-page-code').mod('multiline', 'yes')(
    content()(function() {
        let hideNumbers = this.ctx.lang === 'no-highlight' ||
            this.ctx['wiki-attrs'].hasOwnProperty('nomark') ||
            this.ctx['wiki-attrs'].hasOwnProperty('nohighlight');
        return [
            hideNumbers ? '' : {
                elem: 'line-numbers',
                tag: 'code',
                mix: {
                    block: this.ctx.lang,
                },
                content: Array.from({ length: this.ctx.linesCount }, function(line, lineNumber) {
                    return {
                        elem: 'line-number',
                        content: lineNumber + 1,
                    };
                }),
            },
            {
                elem: 'code',
                tag: 'code',
                mix: {
                    block: this.ctx.lang,
                },
                content: {
                    elem: 'pre',
                    tag: 'pre',
                    content: this.ctx.code,
                },
            },
        ];
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/b-page-code/_multiline/b-page-code_multiline_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-doc/wiki-doc.bemhtml.js */
block('wiki-doc')(
    def()(function() {
        let settings = this.ctx['wiki-attrs'];
        if (settings.magiclinks_url) {
            this.mods.magiclinks = 'yes';
        }

        if (settings.page_path) {
            this.mods.wiki = 'yes';
        }

        return applyNext({ settings: settings, toc: this.ctx.toc });
    }),

    attrs()(function() {
        return {
            'data-wf': JSON.stringify({
                user: {
                    codeTheme: this.ctx['wiki-attrs'].code_theme,
                },
                toc: this.ctx.toc,
                'wiki-attrs': this.ctx['wiki-attrs'],
            }),
        };
    }),

    js()(true),

    mix()({ block: 'woof' })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-doc/wiki-doc.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-cut/wiki-cut.bemhtml.js */
block('wiki-cut')(

    tag()('details'),

    js()(true),

    content()(function() {
        let title = this.ctx.title;

        if (!title || Array.isArray(title) && title.length === 0) {
            title = this.I18N('wiki-cut', 'more');
        } else if (title.block === 'wiki-p') {
            title = title.content;
        }

        return [
            {
                elem: 'summary',
                tag: 'summary',
                content: [
                    {
                        elem: 'summary-inner',
                        content: title,
                    },
                    {
                        block: 'woof-icon',
                        mods: { type: 'awesome-angle-up' },
                    },
                    {
                        block: 'woof-icon',
                        mods: { type: 'awesome-angle-down' },
                    }
                ],
            },
            applyNext(),
        ];
    }),

    elem('summary-inner').tag()('span')
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-cut/wiki-cut.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-cut/_heading/wiki-cut_heading.bemhtml.js */
block('wiki-cut').mod('heading', true)(
    elem('summary-inner').replace()(function() {
        return this.ctx.content;
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-cut/_heading/wiki-cut_heading.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-include/wiki-action-include.bemhtml.js */
block('wiki-action-include')(

    // потому что в js в глобальном WF.getConfig() будет includes_path для корня,
    // а нам нужен includes_path, который был прокинут при рендере инклюда в параметры ыwiki-doc
    js()(function() {
        let js = Object.assign({}, this.ctx.js);

        js.includes_path = this.settings.includes_path || [];

        return js;
    }),

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let linesWidths = [];
        let i;

        for (i = 0; i < 10; i++) {
            linesWidths.push(require('lodash/random')(90, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: [
                {
                    elem: 'preview-title',
                    content: [
                        this.I18N('wiki-action-include', 'page'),
                        {
                            block: 'wiki-action',
                            elem: 'preview-title-placeholder',
                        },
                    ],
                },
                {
                    elem: 'preview-content',
                    content: linesWidths.map(function(lineWidth) {
                        return {
                            elem: 'preview-content-line',
                            attrs: { style: 'width: ' + lineWidth + 'px;' },
                        };
                    }),
                },
            ],
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-include/wiki-action-include.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-formatter/_wrapper/wiki-formatter_wrapper_box.bemhtml.js */
block('wiki-formatter').mod('wrapper', 'box')(

    js()(true),

    content()(function() {
        let prev = this.ctx.content;

        return [
            { elem: 'paranja' },
            prev,
        ];
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/touch.blocks/wiki-formatter/_wrapper/wiki-formatter_wrapper_box.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_code.bemhtml.js */
block('wiki-formatter').mod('format', 'code')(
    content()(function() {
        let mods = {};
        if (this.ctx.multiline) {
            mods.multiline = 'yes';
        } else {
            mods.inline = 'yes';
        }

        return {
            block: 'b-page-code',
            'wiki-attrs': this.ctx['wiki-attrs'],
            code: this.ctx.content,
            lang: this.ctx.lang,
            linesCount: this.ctx.linesCount,
            mods: mods,
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_code.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-math/wiki-math.bemhtml.js */
block('wiki-math')(
    js()((self, { content }) => ({
        tex: content,
        staticHost: self.settings.yastatic_url,
    })),

    content()((self, { style }) => {
        let content = applyNext();

        if (typeof content !== 'string') {
            // Иначе "пустые формулы" будут отображаться как "undefined"
            content = '';
        }

        if (/\\*$/.exec(content)[0].length % 2 > 0) {
            // Если в формуле есть "\", который ничего не экранирует, то надо его удалить,
            // иначе MathJax ничего не отрендерит, оставив на месте плейсхолдер
            content = content.slice(0, -1);
        }

        return `$$(${style})${content}$$`;
    }),

    elem('popup')(
        content()(() => ({
            elem: 'tex-view',
        }))
    ),

    elem('tex-view')(
        tag()('pre')
    ),

    def()(() => applyNext({
        'mods.loading': 'yes',
    }))
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-math/wiki-math.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_csv.bemhtml.js */
block('wiki-formatter').mod('format', 'csv')(
    js()(function() {
        return {
            csv: this.ctx.content,
            delimiter: this.ctx['wiki-attrs'].delimiter,
            head: this.ctx['wiki-attrs'].head,
        };
    }),

    content()(function() {
        return {
            block: 'wiki-spin',
            mods: {
                progress: 'yes',
                type: 'load',
            },
        };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-formatter/_format/wiki-formatter_format_csv.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-magiclink/wiki-magiclink.bemhtml.js */
/* global block, oninit */
// Это все вынесено в шаблон только потому что возможно мы захотим рендерить magiclinks на сервере
// и тогда можно будет его использовать.
// Если это не нужно, то можно перенести всю эту логику преобразования данных в bemjson, куда нибудь в i-magiclinks.
// Внимание: oninit сработает только при первой компиляции шаблонов.
oninit(function(exports, shared) {
    function spreadArray(arr, delim) {
        // perf test: https://www.measurethat.net/Benchmarks/Show/191/10/spreadarray
        let result = [];
        for (let i = 0; i < arr.length; i++) { // eslint-disable-line no-plusplus
            if (i === 0) {
                result.push(arr[i]);
            } else {
                result.push(delim, arr[i]);
            }
        }
        return result;
    }

    function stringToBlock(part) {
        let block = {
            elem: part.type,
            tag: 'span',
            content: part.value.toString(),
        };

        /* eslint-disable no-use-before-define */
        _addColorOptions(part, block);
        _addStrikeOptions(part, block);
        _addActionOptions(part, block);
        /* eslint-enable no-use-before-define */

        return block;
    }

    function listToBlock(part) {
        let sep = (typeof part.separator === 'undefined') ? ' ' : part.separator;
        let block = {
            elem: 'list',
            tag: 'span',
            /* eslint-disable no-use-before-define */
            content: spreadArray(part.value.map(anyToBlock), sep),
        };

        _addColorOptions(part, block);
        _addStrikeOptions(part, block);
        _addActionOptions(part, block);
        /* eslint-enable no-use-before-define */

        return block;
    }

    function imageToBlock(part) {
        return {
            elem: 'image',
            tag: 'span',
            attrs: {
                style: ['background-image: url(', part.src, ')'],
            },
            content: '\u00A0', // U+00A0 (No-break space)
        };
    }

    function userToBlock(part) {
        let login = part.login || part.value;
        let title = part.title || login;
        return {
            elem: 'user',
            tag: 'object',
            content: {
                block: 'wiki-username',
                login: login,
                mods: {
                    style: 'portal',
                    'staff-card': 'yes',
                },
                content: title,
            },
        };
    }

    function anyToBlock(part) {
        let block = '';
        let types = {
            list: listToBlock,
            image: imageToBlock,
            string: stringToBlock,
            user: userToBlock,
        };

        if (types[part.type]) {
            block = types[part.type](part);
        }

        return block;
    }

    function magiclinkToBemBlock(mlData) {
        let block = anyToBlock(mlData);
        // Делаем Root block ссылкой
        if ((typeof mlData.url === 'undefined') || (typeof mlData.url === 'string' && mlData.url !== '')) {
            block.tag = 'a';
            let attrs = {
                href: mlData.url || mlData._requestedUrl,
                target: '_blank',
                // FIXME: прокинуть сюда title c переводами
                title: 'Open in new window',
            };
            block.attrs = shared.BEMContext.prototype.extend(block.attrs || {}, attrs);
            block.mix = block.mix || [];
            block.mix.push({ block: 'wiki-link' });
        }

        return block;
    }

    /* eslint-disable no-param-reassign */
    function _addColorOptions(part, block) {
        if (part.color) {
            block.attrs = block.attrs || {};
            block.attrs.style = block.attrs.style || '';
            block.attrs.style += 'color: ' + part.color;
        }
    }

    function _addStrikeOptions(part, block) {
        if (part.strike) {
            block.elemMods = block.elemMods || {};
            block.elemMods.strike = 'yes';
        }
    }

    function _addActionOptions(part, block) {
        if (part.action) {
            block.mix = block.mix || [];
            block.mix.push({
                block: 'wiki-magiclink-action',
                mods: { type: part.action.type },
                js: {
                    type: part.action.type,
                    url: part.action.url,
                },
            });
        }
    }
    /* eslint-enable no-param-reassign */

    let blockName = 'wiki-magiclink';
    /* eslint-disable no-param-reassign */
    shared.BEMContext.prototype.helpers = shared.BEMContext.prototype.helpers || {};
    shared.BEMContext.prototype.helpers[blockName] = shared.BEMContext.prototype.helpers[blockName] || {};
    /* eslint-enable no-param-reassign */
    let helpersScope = shared.BEMContext.prototype.helpers[blockName];
    helpersScope.magiclinkToBemBlock = magiclinkToBemBlock;
});

block('wiki-magiclink')(
    tag()('span'),

    content()(function() {
        return this.helpers['wiki-magiclink'].magiclinkToBemBlock(this.ctx);
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-magiclink/wiki-magiclink.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-username/_inflecting/wiki-username_inflecting_yes.bemhtml.js */
block('wiki-username').mod('inflecting', 'yes')(
    js()(function() {
        return { case: this.ctx.case, login: this.ctx.login, at: this.ctx.at };
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-username/_inflecting/wiki-username_inflecting_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-li/_checkable/wiki-li_checkable_yes.bemhtml.js */
block('wiki-li').mod('checkable', 'yes').elem('wrapper').content()((self, ctx) => [
    {
        block: self.block,
        elem: 'checkbox-wrapper',
        content: {
            block: self.block,
            elem: 'checkbox',
            tag: 'input',
            attrs: {
                type: 'checkbox',
                disabled: 'disabled',
                checked: ctx['wiki-attrs'].checked,
            },
        }
    },
    applyNext(),
]);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-li/_checkable/wiki-li_checkable_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-username/_staff-card/wiki-username_staff-card_yes.bemhtml.js */
block('wiki-username').mod('staff-card', 'yes')(
    attrs()(function() {
        return Object.assign({}, applyNext(), {
            'data-staff': this.ctx.login,
            'data-staff-host': this.settings.staff_url,
        });
    })
);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-username/_staff-card/wiki-username_staff-card_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action/_autoload/wiki-action_autoload_false.bemhtml.js */
block('wiki-action').mod('autoload', 'false')(

    js()(function() {
        return Object.assign({}, this.ctx.js, {
            bemjson: apply('bemjson'),
            toc: this.toc,
            settings: this.settings,
        });
    }),

    content()(function() {
        return {
            elem: 'content',
            content: [
                `${this.I18N('wiki-action', 'action')} ${this.ctx.name}. `,
                {
                    block: 'wiki-link',
                    mods: { pseudo: 'yes' },
                    mix: { block: 'wiki-action', elem: 'load-link' },
                    content: `${this.I18N('wiki-action', 'load')}.`,
                },
            ],
        };
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action/_autoload/wiki-action_autoload_false.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_expandable/wiki-action-tree-page_expandable_yes.bemhtml.js */
block('wiki-action-tree-page').mod('expandable', 'yes').elem('expand').content()([
    {
        block: 'woof-icon',
        mods: {
            action: 'expand',
            type: 'awesome-angle-right',
        },
    },
    {
        block: 'woof-icon',
        mods: {
            action: 'unexpand',
            type: 'awesome-angle-down',
        },
    },
    {
        block: 'wiki-spin',
        mods: {
            size: 'xxs',
            type: 'expand',
        },
    },
]);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_expandable/wiki-action-tree-page_expandable_yes.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_n.bemhtml.js */
block('wiki-action-tree-page').mod('type', 'n').elem('type-icon').replace()(self => ({
    block: 'woof-icon',
    mods: { type: 'awesome-plus-icon' },
    mix: {
        block: self.block,
        elem: self.elem,
    },
}));

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree-page/_type/wiki-action-tree-page_type_n.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-feed/wiki-action-feed.bemhtml.js */
block('wiki-action-feed')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let linesWidths = [];
        let i;

        for (i = 0; i < 4; i++) {
            linesWidths.push(require('lodash/random')(90, 240));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: {
                elem: 'preview-content',
                content: linesWidths.map(function(lineWidth) {
                    return {
                        elem: 'preview-content-line',
                        attrs: { style: 'width: ' + lineWidth + 'px;' },
                    };
                }),
            },
        };
    }),

    elem('content').content()(function() {
        let data = this.ctx.data;
        let params = this.ctx.params;

        let items = data.map(function(item) {
            return {
                block: 'wiki-action-feed',
                elem: 'item',
                data: item,
                params: params,
            };
        });

        return params.nomark ? items : {
            block: 'wiki-action-feed',
            elem: 'fieldset',
            tag: 'fieldset',
            content: [params.title ? {
                block: 'wiki-action-feed',
                elem: 'fieldset-title',
                tag: 'legend',
                content: params.title,
            } : ''].concat(items),
        };
    }),

    elem('item').content()(function() {
        let data = this.ctx.data;
        let params = this.ctx.params;

        return [
            params.time ? {
                block: 'wiki-action-feed',
                elem: 'item-time',
                tag: 'tt',
                content: data.formattedPubDate,
            } : '',
            params.notitlelink ? {
                block: 'wiki-action-feed',
                elem: 'item-title',
                content: data.title,
            } : {
                block: 'wiki-link',
                target: '_blank',
                mix: { block: 'wiki-action-feed', elem: 'item-title' },
                href: data.link,
                content: data.title,
            },
            params.today && params.time && data.today ? {
                block: 'wiki-action-feed',
                elem: 'item-today',
                tag: 'sup',
                content: this.I18N('wiki-action-feed', 'today'),
            } : '',
        ];
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-feed/wiki-action-feed.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree/wiki-action-tree.bemhtml.js */
block('wiki-action-tree')(

    mix()({ block: 'wiki-action', mods: { mixed: 'yes', loading: 'yes' } }),

    content()(function() {
        let linesWidths = [];
        let i;

        for (i = 0; i < 10; i++) {
            linesWidths.push(require('lodash/random')(90, 360));
        }

        return {
            elem: 'preview',
            mix: { block: 'wiki-action', elem: 'preview' },
            content: [
                {
                    elem: 'preview-title',
                    content: [
                        this.I18N('wiki-action-tree', 'cluster_tree'),
                        {
                            block: 'wiki-action',
                            elem: 'preview-title-placeholder',
                        },
                    ],
                },
                {
                    elem: 'preview-content',
                    content: linesWidths.map(function(lineWidth) {
                        return {
                            elem: 'preview-content-line',
                            attrs: { style: 'width: ' + lineWidth + 'px;' },
                        };
                    }),
                },
            ],
        };
    }),

    elem('content').content()(function() {
        const urlJoin = require('url-join');
        let totalData = this.ctx.data;
        let pageData = totalData.page;
        let self = this;

        return [
            {
                elem: 'head',
                content: [
                    {
                        elem: 'title',
                        content: [
                            this.I18N('wiki-action-tree', 'cluster_tree') + ' ', {
                                block: 'wiki-link',
                                href: urlJoin(this.ctx.wikiUrl, pageData.url),
                                content: pageData.title || pageData.cluster,
                            },
                        ],
                    },
                    totalData.expand_all_url && {
                        elem: 'expand-all',
                        content: [
                            {
                                block: 'wiki-link',
                                mods: { pseudo: 'yes' },
                                content: this.I18N('wiki-action-tree', 'expand_all'),
                            },
                            totalData.limit_exceeded && {
                                elem: 'not-full-loaded',
                            },
                        ],
                    },
                ],
            }, {
                block: 'wiki-spin',
                mods: {
                    size: 'xxs',
                    type: 'update-tree',
                },
            }, {
                elem: 'tree',
                content: totalData.subpages && totalData.subpages.map(function(subpage) {
                    return {
                        block: 'wiki-action-tree-page',
                        mods: {
                            expandable: subpage.expand_url || subpage.subpages.length ? 'yes' : '',
                            expanded: subpage.subpages.length ? 'yes' : '',
                            'data-loaded': subpage.subpages.length ? 'yes' : '',
                            type: subpage.page.type.toLowerCase(),
                        },
                        data: subpage,
                        wikiUrl: self.ctx.wikiUrl,
                        staffUrl: self.ctx.staffUrl,
                        isWiki: self.ctx.isWiki,
                    };
                }),
            },
        ];
    }),

    elem('not-full-loaded').content()(function() {
        return this.I18N('wiki-action-tree', 'not_full_loaded');
    }),

    elem('full-loaded').content()(function() {
        return this.I18N('wiki-action-tree', 'full_loaded');
    })

);

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/wiki-action-tree/wiki-action-tree.bemhtml.js */
/* begin: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/i-extensions/i-extensions.bemhtml.js */
block('*').match(function() {
    return this.settings && this.settings.extensions && this.settings.extensions[this.block];
}).def()(function() {
    return applyNext({
        ctx: Object.assign({}, this.ctx, this.settings.extensions[this.block](this.ctx)),
    });
});

/* end: /place/sandbox-data/ramdrive/725415236/tools/packages/woof/common.blocks/i-extensions/i-extensions.bemhtml.js */
oninit(function(exports, context) {
    var BEMContext = exports.BEMContext || context.BEMContext;
    // Provides third-party libraries from different modular systems
    BEMContext.prototype.require = function(lib) {
       return __bem_xjst_libs__[lib];
    };
});;
});
api.exportApply(exports);
/// -------------------------------------
/// ------ BEM-XJST User-code End -------
/// -------------------------------------


        return exports;
    };

    

    var defineAsGlobal = true;

    // Provide with CommonJS
    if (typeof module === 'object' && typeof module.exports === 'object') {
        exports['BEMHTML'] = buildBemXjst({
    
}
);
        defineAsGlobal = false;
    }

    // Provide to YModules
    if (typeof modules === 'object') {
        modules.define(
            'BEMHTML',
            [],
            function(
                provide
                
                ) {
                    provide(buildBemXjst({
    
}
));
                }
            );

        defineAsGlobal = false;
    }

    // Provide to global scope
    if (defineAsGlobal) {
        BEMHTML = buildBemXjst({
    
}
);
        global['BEMHTML'] = BEMHTML;
    }
})(typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : this);
