import { d as deleteDatabase } from './utils-66091b10.js';

// Since this library proxies IDB, I haven't retested all of IDB. I've tried to cover parts of the
mocha.setup('tdd');
function loadScript(url) {
    return new Promise((resolve, reject) => {
        const script = document.createElement('script');
        script.type = 'module';
        script.src = url;
        script.onload = () => resolve();
        script.onerror = () => reject(Error('Script load error'));
        document.body.appendChild(script);
    });
}
(async function () {
    const edgeCompat = navigator.userAgent.includes('Edge/');
    if (!edgeCompat)
        await loadScript('./open.js');
    await loadScript('./main.js');
    if (!edgeCompat)
        await loadScript('./iterate.js');
    await deleteDatabase();
    mocha.run();
})();
