import { DBSchema, IDBPDatabase, DeleteDBCallbacks } from '../src/';
export interface ObjectStoreValue {
    id: number;
    title: string;
    date: Date;
}
export interface TestDBSchema extends DBSchema {
    'key-val-store': {
        key: string;
        value: number;
    };
    'object-store': {
        value: ObjectStoreValue;
        key: number;
        indexes: {
            date: Date;
            title: string;
        };
    };
}
export declare const dbName = "test-db";
export declare function getNextVersion(): number;
export declare function openDBWithSchema(): Promise<IDBPDatabase<TestDBSchema>>;
export declare function openDBWithData(): Promise<IDBPDatabase<TestDBSchema>>;
export declare function deleteDatabase(callbacks?: DeleteDBCallbacks): Promise<void>;
//# sourceMappingURL=utils.d.ts.map