"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = _default;
exports.messages = exports.ruleName = void 0;

var _lodash = require("lodash");

var _stylelint = require("stylelint");

var _utils = require("../../utils");

var sassAtRules = ["at-root", "content", "debug", "each", "else", "else if", "error", "extend", "for", "forward", "function", "if", "import", "include", "media", "mixin", "return", "use", "warn", "while"];
var ruleToCheckAgainst = "at-rule-no-unknown";
var ruleName = (0, _utils.namespace)(ruleToCheckAgainst);
exports.ruleName = ruleName;

var messages = _stylelint.utils.ruleMessages(ruleName, {
  rejected: _stylelint.rules[ruleToCheckAgainst].messages.rejected
});

exports.messages = messages;

function _default(primaryOption, secondaryOptions) {
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: primaryOption
    }, {
      actual: secondaryOptions,
      possible: {
        ignoreAtRules: [_lodash.isRegExp, _lodash.isString]
      },
      optional: true
    });

    if (!validOptions) {
      return;
    }

    var optionsAtRules = secondaryOptions && secondaryOptions.ignoreAtRules;
    var ignoreAtRules = sassAtRules.concat(optionsAtRules || []);
    var defaultedOptions = Object.assign({}, secondaryOptions, {
      ignoreAtRules: ignoreAtRules
    });

    _stylelint.utils.checkAgainstRule({
      ruleName: ruleToCheckAgainst,
      ruleSettings: [primaryOption, defaultedOptions],
      root: root
    }, function (warning) {
      var name = warning.node.name;

      if (!ignoreAtRules.includes(name)) {
        _stylelint.utils.report({
          message: messages.rejected("@".concat(name)),
          ruleName: ruleName,
          result: result,
          node: warning.node,
          line: warning.line,
          column: warning.column
        });
      }
    });
  };
}