"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var reduceHeadersObject_1 = require("./reduceHeadersObject");
/**
 * Converts a given headers object to a new `Headers` instance.
 */
function objectToHeaders(obj) {
    return reduceHeadersObject_1.reduceHeadersObject(obj, function (headers, name, value) {
        var values = [].concat(value);
        values.forEach(function (value) {
            headers.append(name, value);
        });
        return headers;
    }, new Headers());
}
exports.objectToHeaders = objectToHeaders;
