from datetime import timedelta

from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.common.helpers import tables_helpers
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.BarNavig)
    extra_dirs = [
        config.VisitDir,
        config.VisitPrivateDir,
        config.CheventDir,
        config.ReqansDir,
        config.FacebookAdsDir,
    ]

    while True:
        with yt_client.Transaction() as tx:
            date = tables_helpers.get_unprocessed_date(yt_client, tracker, extra_dirs, logger)

            if date is None:
                logger.info("No date to process")
                break

            logger.info("Processing date %s", date)

            bar_navig_table_path = ypath.ypath_join(config.BarNavig.SourceDir, date)
            output_table_path = ypath.ypath_join(config.OutputDir, date)

            yql_query_params = {
                "bar_navig": bar_navig_table_path,
                "visit": ypath.ypath_join(config.VisitDir, date),
                "visit_private": ypath.ypath_join(config.VisitPrivateDir, date),
                "chevent": ypath.ypath_join(config.CheventDir, date),
                "reqans": ypath.ypath_join(config.ReqansDir, date),
                "facebook": ypath.ypath_join(config.FacebookAdsDir, date),
                "yandexuid_to_crypta_id": config.YandexuidToCryptaIdTable,
                "output": output_table_path,
            }

            yql_helpers.run_query("/query/collect_history.yql", config.Yt, yql_query_params, logger, tx=tx)

            tracker.add_processed_tables(yt_client, [bar_navig_table_path])

        yt_helpers.set_ttl(output_table_path, timedelta(days=config.HistoryTtlDays), yt_client=yt_client)
