import os
import yt.wrapper as yt

from crypta.graph.mrcc_opt.python.native import mrcc


def find_components():
    yt_proxy = os.getenv("YT_PROXY")
    yt_token = os.getenv("YT_TOKEN")
    yt_pool = os.getenv("YT_POOL", "mskorkhod")

    inp = "//statbox/business-dwh/res/latest/clusters/stage_03/uv_pairs"
    outp = "//home/crypta/team/mskorokhod/mrcc/components"
    workdir = "//home/crypta/team/mskorokhod/mrcc/workdir"

    yt.create("map_node", workdir, recursive=True, force=True)

    with yt.Transaction() as trx:
        converged = mrcc.find_components(
            proxy=yt_proxy,
            token=yt_token,
            transaction_id=str(trx.transaction_id),
            pool=yt_pool,
            source=inp,
            destination=outp,
            workdir=workdir,
            previous_labels="",
            edge_first_fields=["u"],
            edge_second_fields=["v"],
            vertex_fields=["v"],
            component_field="component_id",
            max_iterations_count=200,
            with_start_preparing=True,
            with_finish_preparing=True,
            script_name="mrcc",
        )

    if not converged:
        raise Exception("MRCC has not converged")


def main():
    find_components()


if __name__ == "__main__":
    main()
