from yt.wrapper import ypath

from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import (
    path_utils,
    yt_helpers,
)
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.BarNavig)

    while True:
        with yt_client.Transaction() as tx:
            unprocessed_table_paths = tracker.get_unprocessed_tables(yt_client, 1)
            logger.info("Unprocessed tables %s", unprocessed_table_paths)

            if not unprocessed_table_paths:
                logger.info("No tables to process")
                break

            src_table = unprocessed_table_paths[0]
            date = path_utils.get_basename(src_table)

            yql_query_params = {
                "input_table": src_table,
                "output_table": ypath.ypath_join(config.OutputDir, date),
            }

            yql_helpers.run_query("/query/parse_facebook_ads.yql", config.Yt, yql_query_params, logger, tx=tx)

            tracker.add_processed_tables(yt_client, [src_table])
