import logging

from crypta.lib.python.getoptpb import ParsePbOptions
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yql import executer
from crypta.lib.python.yt import yt_helpers
from crypta.adhoc.smart.tasks.join_with_crypta_id.bin.config_pb2 import TConfig
from crypta.adhoc.smart.tasks.join_with_crypta_id.lib import prepare_data


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger.info("Collecting stats from Coucbase dump")
    config = ParsePbOptions(TConfig)

    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    yql_executer = executer.get_executer_from_proto(config.Yt)

    prepare_data.run(
        yt_client,
        yql_executer,
        config.CounterId,
        config.OfferTable,
        config.MappingTable,
        config.ResultTable,
    )

    logger.info("Done")
