import logging

from yabs.proto.user_profile_pb2 import Profile

logger = logging.getLogger(__name__)

ACTION_BITS = 1 << Profile.OfferProfile.ActionBitsEnum.PURCHASE
SELECT_TYPE = 137

QUERY_TEMPLATE = """
INSERT INTO `{result_table}` WITH TRUNCATE
SELECT
    {counter_id} as counter_id,
    Digest::Md5HalfMix(CAST(offer.product_id as String)) as offer_id_md5,
    {action_bits} as action_bits,
    DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(offer.`date`))) as update_time,
    {select_type} as select_type,
    CAST(mapping.target_id as Uint64) as crypta_id,
FROM `{offer_table}` as offer
JOIN `{mapping_table}` as mapping
ON offer.hash == mapping.id;
"""


def run(yt_client, yql_executer, counter_id, offer_table, mapping_table, result_table):
    with yt_client.Transaction() as tx:
        query = QUERY_TEMPLATE.format(
            counter_id=counter_id,
            offer_table=offer_table,
            mapping_table=mapping_table,
            result_table=result_table,
            action_bits=ACTION_BITS,
            select_type=SELECT_TYPE,
        )

        logger.info("Running query:\n%s", query)
        yql_executer(query, transaction=tx.transaction_id, syntax_version=1)

        logger.info("Done.")

    return
