import logging

from crypta.lib.python.getoptpb import ParsePbOptions
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.adhoc.smart.tasks.upload_csv.config_pb2 import TConfig

logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger.info("Uploading offer CSV data to YT")
    config = ParsePbOptions(TConfig)

    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    rows = []
    with open(config.LocalPath) as f:
        next(f)
        for line in f:
            hash, trn_id, date, product_id, qty, value = line.strip().split(';')
            rows.append({'hash': hash, 'trn_id': int(trn_id), 'date': date, 'product_id': int(product_id), 'qty': float(qty), 'value': float(value)})

    schema = [
        {"name": "hash", "type": "string"},
        {"name": "trn_id", "type": "int64"},
        {"name": "date", "type": "string"},
        {"name": "product_id", "type": "int64"},
        {"name": "qty", "type": "double"},
        {"name": "value", "type": "double"}
    ]

    yt_client.create_table(config.YtPath, attributes={"schema": schema})
    yt_client.write_table(config.YtPath, rows)
